

      
;************************************************************
;	Wait for Commands
;************************************************************

.DSEG
monitor_inptr:
	.byte	1

.CSEG

monitor_test:
	ldi	r24	,low(uart_ibuf)		;store character as uart_ibuf [uart_iput]
	ldi	r25	,high(uart_ibuf)
	lds	r16	,uart_iput
	clr	r17
	lds	r18	,uart_iget
	ldi	zl	,low((monitor_test_command<<1))
	ldi	zh	,high((monitor_test_command<<1))
monitor_test_loop:
	cp	r16	,r18		;check if buffer full
	breq	monitor_test_full

	lpm	r0	,Z+
	movw	xh:xl	,r25:r24
	add	xl	,r16
	adc	xh	,r17
	st	X	,r0

	inc	r16			;uart_iput ++ (post increment)
	andi	r16	,UART_ISIZE-1
	sts	uart_iput	,r16

	tst	r0
	brne	monitor_test_loop

monitor_test_full:
	rjmp	monitor

;************************************************************

monitor:
	lds	r16	,monitor_inptr
	tst	r16
	brpl	monitor_no_prompt

	ldi	zl	,low(monitor_msg_prompt<<1)
	ldi	zh	,high(monitor_msg_prompt<<1)
	call	puts_rom
	ldi	r16	,0
	sts	monitor_inptr	,r16

monitor_no_prompt:
	call	gets
	brtc	monitor_exit

	rcall	next_word
	brtc	monitor_error

	ldi	r16	,L_CMD
	rcall	find_label
	brtc	monitor_error

	mov	zl	,xl
	mov	zh	,xh
	icall

	brts	monitor_init

monitor_error:
	ldi	zl	,low(monitor_msg_error<<1)
	ldi	zh	,high(monitor_msg_error<<1)
	call	puts_rom

	rjmp	monitor_init

monitor_init:
	ldi	r16	,low(uart_cmd)
	sts	cmd_ptr	,r16
	ldi	r16	,high(uart_cmd)
	sts	cmd_ptr+1	,r16
	ldi	r16	,-1
	sts	monitor_inptr	,r16
monitor_exit:
	ret

monitor_msg_error:
	.db	"ERROR",13, 0, 0
monitor_msg_prompt:
	.db	62, 0


;************************************************************
;	Monitor Command DB
;	Display Byte
;
;	DB <adress|label>
;************************************************************

monitor_db:
	ldi	r16	,L_BREG | L_BRAM	;search reg/io/ram byte adress
	rcall	next_adress
	brtc	monitor_db_exit

	putc	'0'
	putc	'x'
	ld	r16	,X
	push	r16
	rcall	printf_byte_hex
	putc	' '
	putc	'b'
	pop	r16
	rcall	printf_byte_binary
	putc	13

monitor_db_exit:
	ret


;************************************************************
;	Print Byte as Hex-String
;	R16	: Byte
;************************************************************
	
printf_byte_hex:
	push	r16
	push	zl
	push	zh
	push	r0

	ldi	zl	,low(hex_digits<<1)
	ldi	zh	,high(hex_digits<<1)
	push	r16
	swap	r16
	andi	r16	,0x0F
	add	zl	,r16
	clr	r16
	adc	zh	,r16
	lpm
	mov	r16	,r0
	call	putc

	ldi	zl	,low(hex_digits<<1)
	ldi	zh	,high(hex_digits<<1)
	pop	r16
	andi	r16	,0x0F
	add	zl	,r16
	clr	r16
	adc	zh	,r16
	lpm
	mov	r16	,r0
	call	putc

	pop	r0
	pop	zh
	pop	zl
	pop	r16
	ret

hex_digits:
	.db	48,49,50,51,52,53,54,55
	.db	56,57,65,66,67,68,69,70

;************************************************************
;	print one byte as Binary
;	r16 : byte to print
;************************************************************

printf_byte_binary:
	push	r16
	push	r0
	push	r17

	mov	r0	,r16
	ldi	r17	,8

print_byte_binary_loop:
	rol	r0
	ldi	r16	,48		;'0'
	brcc	print_byte_binary_null
	ldi	r16	,49		;'1'

print_byte_binary_null:
	rcall	putc
	dec	r17
	brne	print_byte_binary_loop

	pop	r17
	pop	r0
	pop	r16
	ret


;************************************************************
;	Monitor Command DW
;	Display Word
;
;	DW <adress|label>
;************************************************************

monitor_dw:
	ldi	r16	,L_WREG | L_WRAM	;search reg/ram word adress
	rcall	next_adress
	brtc	monitor_dw_exit

	putc	'0'
	putc	'x'
	cli
	ld	r16	,X+
	ld	r17	,X
	sei
	rcall	printf_byte_hex
	mov	r16	,r17
	rcall	printf_byte_hex
	putc	13

monitor_dw_exit:
	ret


;************************************************************
;	Monitor Command DL
;	Display Long
;
;	DL <adress|label>
;************************************************************

monitor_dl:
	ldi	r16	,L_LRAM		;search ram long adress
	rcall	next_adress
	brtc	monitor_dl_exit

	putc	'0'
	putc	'x'
	cli
	ld	r16	,X+
	ld	r17	,X+
	ld	r18	,X+
	ld	r19	,X
	sei

	rcall	printf_byte_hex
	mov	r16	,r17
	rcall	printf_byte_hex
	mov	r16	,r18
	rcall	printf_byte_hex
	mov	r16	,r19
	rcall	printf_byte_hex
	putc	13

monitor_dl_exit:
	ret


;************************************************************
;	Monitor Command DF
;	Display Float
;
;	DF <adress|label>
;************************************************************

monitor_df:
	ldi	r16	,L_FRAM	;search ram float adress
	rcall	next_adress
	brtc	monitor_df_exit

monitor_df_print:
	call	flt_load_x
	call	flt_print
	putc	13

monitor_df_exit:
	ret


;************************************************************
;	Monitor Command MB
;	Modify Byte
;
;	MB <adress|label> <byte>
;************************************************************

monitor_mb:
	ldi	r16	,L_BREG | L_IO | L_BRAM	;search reg/io/ram byte adress
	rcall	next_adress
	brtc	monitor_mb_exit

	mov	r0	,xl
	mov	r1	,xh

	rcall	next_int_value			;value
	brtc	monitor_mb_exit

	mov	xl	,r0
	mov	xh	,r1

	andi	r16	,L_BREG|L_BRAM	;label is register or ram
	breq	monitor_mb_no_reg_or_ram

	st	X	,AKKU_8		;write cpu register
	rjmp	monitor_mb_exit

monitor_mb_no_reg_or_ram:
	adiw	xh:xl	,0x20		;add base adress for i/o area
	st	X	,AKKU_8		;write i/o register
	
monitor_mb_exit:
	ret


;************************************************************
;	Monitor Command MW
;	Modify Word
;
;	MW <adress|label> <word>
;************************************************************

monitor_mw:
	ldi	r16	,L_WRAM		;search ram word adress
	rcall	next_adress
	brtc	monitor_mw_exit

	mov	r0	,xl
	mov	r1	,xh

	rcall	next_int_value			;value
	brtc	monitor_mw_exit

	mov	xl	,r0
	mov	xh	,r1

	cli
	st	X+	,AKKU_7
	st	X+	,AKKU_8
	sei

monitor_mw_exit:
	ret


;************************************************************
;	Monitor Command ML
;	Modify Long
;
;	MW <adress|label> <long>
;************************************************************

monitor_ml:
	ldi	r16	,L_LRAM		;search ram word adress
	rcall	next_adress
	brtc	monitor_ml_exit

	mov	r0	,xl
	mov	r1	,xh

	rcall	next_int_value			;value
	brtc	monitor_mw_exit

	mov	xl	,r0
	mov	xh	,r1

	cli
	st	X+	,AKKU_5
	st	X+	,AKKU_6
	st	X+	,AKKU_7
	st	X+	,AKKU_8
	sei

monitor_ml_exit:
	ret


;************************************************************
;	Monitor Command MF
;	Modify Float
;
;	MB <adress|label> <float>
;************************************************************

monitor_mf:
	ldi	r16	,L_FRAM	;search ram float adress
	rcall	next_adress
	brtc	monitor_mf_exit

	push	xl
	push	xh

	rcall	next_flt_value

	pop	xh
	pop	xl
	brtc	monitor_mf_exit

	call	flt_store_x

monitor_mf_exit:
	ret


;************************************************************
next_adress:
	rcall	next_word			;label or address
	brtc	next_adress_exit

	rcall	find_label
	brts	next_adress_exit		;OK, label found

	rcall	monitor_atoi_x
	mov	xl	,AKKU_8
	mov	xh	,AKKU_7

next_adress_exit:
	ret


;************************************************************
next_int_value:
	rcall	next_word
	brtc	next_value_exit

	rjmp	monitor_atoi_x

next_flt_value:
	rcall	next_word
	brtc	next_value_exit

	jmp	flt_atof_x

next_value_exit:
	ret


;************************************************************
;	print all ports
;************************************************************

monitor_ports:
	puts_rom	monitor_ports_header
	putc	'A'
	putc	':'
	putc	' '
	in	r16	,PORTA
	rcall	printf_byte_binary
	putc	' '
	in	r16	,PINA
	rcall	printf_byte_binary
	putc	' '
	in	r16	,DDRA
	rcall	printf_byte_binary
	putc	13

	putc	'B'
	putc	':'
	putc	' '
	in	r16	,PORTB
	rcall	printf_byte_binary
	putc	' '
	in	r16	,PINB
	rcall	printf_byte_binary
	putc	' '
	in	r16	,DDRB
	rcall	printf_byte_binary
	putc	13

	putc	'C'
	putc	':'
	putc	' '
	in	r16	,PORTC
	rcall	printf_byte_binary
	putc	' '
	in	r16	,PINC
	rcall	printf_byte_binary
	putc	' '
	in	r16	,DDRC
	rcall	printf_byte_binary
	putc	13

	putc	'D'
	putc	':'
	putc	' '
	in	r16	,PORTD
	rcall	printf_byte_binary
	putc	' '
	in	r16	,PIND
	rcall	printf_byte_binary
	putc	' '
	in	r16	,DDRD
	rcall	printf_byte_binary
	putc	13

	putc	'E'
	putc	':'
	putc	' '
	in	r16	,PORTE
	rcall	printf_byte_binary
	putc	' '
	in	r16	,PINE
	rcall	printf_byte_binary
	putc	' '
	in	r16	,DDRE
	rcall	printf_byte_binary
	putc	13

	;putc	'F'
	;putc	':'
	;putc	' '
	;lds	r16	,PORTF
	;rcall	printf_byte_binary
	;putc	' '
	;lds	r16	,PINF
	;rcall	printf_byte_binary
	;putc	' '
	;lds	r16	,DDRF
	;rcall	printf_byte_binary
	;putc	13

	;putc	'G'
	;putc	':'
	;putc	' '
	;lds	r16	,PORTG
	;rcall	printf_byte_binary
	;putc	' '
	;lds	r16	,PING
	;rcall	printf_byte_binary
	;putc	' '
	;lds	r16	,DDRG
	;rcall	printf_byte_binary
	;putc	13

	ret

monitor_ports_header:
	.db	"   PORT      PIN       DDR"
	.db	13, 0


;************************************************************
;	get next word from command line
;
;	arguments:
;
;	returns:
;	xh:xl	: pointer to null terminated string
;	t-flag	: 1=OK,found
;	
;	globals:
;	cmd_ptr	: command line pointer
;************************************************************

next_word:
	push	r16
	push	yl
	push	yh

	clt				;FALSE

	lds	xl	,cmd_ptr		;load pointer
	lds	xh	,cmd_ptr+1

next_expr_loop1:
	ld	r16	,X		;null character ?
	tst	r16
	breq	next_expr_exit

	cpi	r16	,32		;space
	brne	next_expr_found

	adiw	xh:xl	,1		;next character
	rjmp	next_expr_loop1

next_expr_found:
	set				;TRUE

	mov	yl	,xl
	mov	yh	,xh

next_expr_loop2:
	ld	r16	,Y		;load character
	tst	r16
	brne	next_expr_not_null

	sts	cmd_ptr	,yl		;null byte
	sts	cmd_ptr+1	,yh
	rjmp	next_expr_exit

next_expr_not_null:
	cpi	r16	,32		;space
	breq	next_expr_space

	adiw	yh:yl	,1
	rjmp	next_expr_loop2

next_expr_space:
	ldi	r16	,0
	st	Y+	,r16
	sts	cmd_ptr	,yl
	sts	cmd_ptr+1	,yh

next_expr_exit:
	pop	yh
	pop	yl
	pop	r16
	ret


;*****************************************************************************************
;Convert Integer to String
;
;r17:r16	Number
;r18	Digits (max 5)
;xh:xl	String
;*****************************************************************************************

itoa_digits:	.db	"0123456789ABCDEF"
itoa_dec_numbers:	.dw	1,10,100,1000,10000
itoa_hex_numbers:	.dw	0x0001,0x0010,0x0100,0x1000

itoa:
	push	r16
	push	r17
	push	r18
	push	r19
	push	xl
	push	xh
	push	zl
	push	zh

	dec	r18	
	lsl	r18
itoa_loop:
	ldi	zl	,low(itoa_dec_numbers<<1)
	ldi	zh	,high(itoa_dec_numbers<<1)
	add	zl	,r18
	clr	r0
	adc	zh	,r0

	ldi	r19	,0
	lpm	r0	,Z+
	lpm	r1	,Z+

itoa_sub:
	inc	r19
	sub	r16	,r0
	sbc	r17	,r1
	brcc	itoa_sub

	dec	r19
	add	r16	,r0
	adc	r17	,r1

	ldi	zl	,low(itoa_digits<<1)
	ldi	zh	,high(itoa_digits<<1)
	add	zl	,r19
	clr	r0
	adc	zh	,r0
	lpm	r19	,Z
	st	X+	,r19

	subi	r18	,2
	brpl	itoa_loop

	pop	zh
	pop	zl
	pop	xh
	pop	xl
	pop	r19
	pop	r18
	pop	r17
	pop	r16
	ret


;************************************************************
;	Convert ASCII-String to Binary Number
;	X Register points to String
;************************************************************

monitor_atoi_x:
	push	r16
	push	r17
	push	r18
	push	xl
	push	xh

	clr	AKKU_S
	clr	AKKU_2
	clr	AKKU_3
	clr	AKKU_4
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8
	clt

	ldi	r17	,0
	ld	r16	,X
	cpi	r16	,'-'
	brne	akku_atoi_no_minus

	ldi	r17	,1
	adiw	xh:xl	,1

akku_atoi_no_minus:
	ld	r16	,X
	cpi	r16	,'0'
	brne	akku_atoi_dezimal

	adiw	xh:xl	,1
	ld	r16	,X+
	cpi	r16	,'B'
	breq	akku_atoi_binary

	cpi	r16	,'X'
	breq	akku_atoi_hex


	sbiw	xh:xl	,1

akku_atoi_octal:
	set
	ld	r16	,X+
	subi	r16	,'0'
	brmi	akku_atoi_exit		;< '0'

	cpi	r16	,8
	brge	akku_atoi_exit		;> '7'

	ldi	r18	,3

akku_atoi_octal_shift:
	lsl	AKKU_S
	rol	AKKU_2
	rol	AKKU_3
	rol	AKKU_4
	rol	AKKU_5
	rol	AKKU_6
	rol	AKKU_7
	rol	AKKU_8
	dec	r18
	brne	akku_atoi_octal_shift
	
	or	AKKU_8	,r16
	rjmp	akku_atoi_octal
akku_atoi_dezimal:
	ld	r16	,X+
	subi	r16	,'0'
	brmi	akku_atoi_exit		;< '0'

	cpi	r16	,10
	brge	akku_atoi_exit		;> '9'

	set
	rcall	akku_mal10
	add	AKKU_8	,r16
	clr	r16
	adc	AKKU_7	,r16
	adc	AKKU_6	,r16
	adc	AKKU_5	,r16
	adc	AKKU_4	,r16
	adc	AKKU_3	,r16
	adc	AKKU_2	,r16
	adc	AKKU_S	,r16
	rjmp	akku_atoi_dezimal

akku_atoi_binary:
	ld	r16	,X+
	subi	r16	,'0'
	brmi	akku_atoi_exit		;< '0'

	cpi	r16	,2
	brge	akku_atoi_exit		;> '1'

	set
	lsl	AKKU_8
	rol	AKKU_7
	rol	AKKU_6
	rol	AKKU_5
	rol	AKKU_4
	rol	AKKU_3
	rol	AKKU_2
	rol	AKKU_S
	or	AKKU_8	,r16
	rjmp	akku_atoi_binary

akku_atoi_hex:
	ld	r16	,X+

	cpi	r16	,'0'		;< '0'
	brmi	akku_atoi_exit

	cpi	r16	,'F'+1		;> 'F'
	brge	akku_atoi_exit

	cpi	r16	,'9'+1		;> '9'
	brge	akku_atoi_hex_not_09

	subi	r16	,'0'
	rjmp	akku_atoi_hex_calc

akku_atoi_exit:
	tst	r17
	breq	akku_atoi_positive

	com	AKKU_8
	com	AKKU_7
	com	AKKU_6
	com	AKKU_5
	com	AKKU_4
	com	AKKU_3
	com	AKKU_2
	com	AKKU_S
	ldi	r16	,0xFF
	sub	AKKU_8	,r16
	sbc	AKKU_7	,r16
	sbc	AKKU_6	,r16
	sbc	AKKU_5	,r16
	sbc	AKKU_4	,r16
	sbc	AKKU_3	,r16
	sbc	AKKU_2	,r16
	sbc	AKKU_S	,r16

akku_atoi_positive:
	pop	xh
	pop	xl
	pop	r18
	pop	r17
	pop	r16
	ret

akku_atoi_hex_not_09:		
	cpi	r16	,65		;< 'A'
	brmi	akku_atoi_exit
	
	subi	r16	,65 - 10

akku_atoi_hex_calc:
	set

	ldi	r18	,4
akku_atoi_hex_shift:
	lsl	AKKU_8
	rol	AKKU_7
	rol	AKKU_6
	rol	AKKU_5
	rol	AKKU_4
	rol	AKKU_3
	rol	AKKU_2
	rol	AKKU_S
	dec	r18
	brne	akku_atoi_hex_shift

	or	AKKU_8	,r16
	rjmp	akku_atoi_hex

	
	

;************************************************************
;	Multiply Akku by 10
;************************************************************

akku_mal10:
	push	r0
	push	AKKU_S
	push	AKKU_2
	push	AKKU_3
	push	AKKU_4
	push	AKKU_5
	push	AKKU_6
	push	AKKU_7
	mov	r0	,AKKU_8

	lsl	AKKU_8
	rol	AKKU_7
	rol	AKKU_6
	rol	AKKU_5
	rol	AKKU_4
	rol	AKKU_3
	rol	AKKU_2
	rol	AKKU_S

	lsl	AKKU_8
	rol	AKKU_7
	rol	AKKU_6
	rol	AKKU_5
	rol	AKKU_4
	rol	AKKU_3
	rol	AKKU_2
	rol	AKKU_S

	add	AKKU_8	,r0
	pop	r0
	adc	AKKU_7	,r0
	pop	r0
	adc	AKKU_6	,r0
	pop	r0
	adc	AKKU_5	,r0
	pop	r0
	adc	AKKU_4	,r0
	pop	r0
	adc	AKKU_3	,r0
	pop	r0
	adc	AKKU_2	,r0
	pop	r0
	adc	AKKU_S	,r0

	lsl	AKKU_8
	rol	AKKU_7
	rol	AKKU_6
	rol	AKKU_5
	rol	AKKU_4
	rol	AKKU_3
	rol	AKKU_2
	rol	AKKU_S

	pop	r0
	ret
	
.MACRO	a_mul_10
	call	akku_mal10
.ENDMACRO


;************************************************************
;	find label
;	xh:xl	: pointer to label name
;	r16 	: type of label
;
;	xh:xl	:adress
;	t-flag	:1=found
;************************************************************

find_label:
	push	yl
	push	yh

	ldi	yl	,low((monitor_label_tab<<1))
	ldi	yh	,high((monitor_label_tab<<1))
	rcall	find_label_sub
	brts	find_label_end

	ldi	yl	,low((flt_label_tab<<1))
	ldi	yh	,high((flt_label_tab<<1))
	rcall	find_label_sub
	brts	find_label_end

	ldi	yl	,low((mco_label_tab<<1))
	ldi	yh	,high((mco_label_tab<<1))
	rcall	find_label_sub
	brts	find_label_end

	ldi	yl	,low((tgo_label_tab<<1))
	ldi	yh	,high((tgo_label_tab<<1))
	rcall	find_label_sub
	brts	find_label_end

	ldi	yl	,low((cor_label_tab<<1))
	ldi	yh	,high((cor_label_tab<<1))
	rcall	find_label_sub
	brts	find_label_end

	ldi	yl	,low((alg_label_tab<<1))
	ldi	yh	,high((alg_label_tab<<1))
	rcall	find_label_sub
	brts	find_label_end

	ldi	yl	,low((mot_label_tab<<1))
	ldi	yh	,high((mot_label_tab<<1))
	rcall	find_label_sub
	brts	find_label_end


find_label_end:
	pop	yh
	pop	yl
	ret

find_label_sub:
	push	r0
	push	r1
	push	r2
	push	zl
	push	zh

	mov	r1	,xl		;save string pointer
	mov	r2	,xh

	sbiw	yh:yl	,LABEL_LEN + 4	
	clt				;set status NOT OK

find_label_next:
	adiw	yh:yl	,LABEL_LEN + 4	;next entry

	mov	zl	,yl		;load label type
	mov	zh	,yh
	adiw	zh:zl	,2
	lpm

	tst	r0			;end of table (0)
	breq	find_label_exit

	and	r0	,r16		;type OK ?
	breq	find_label_next			;no, look at next entry

	mov	xl	,r1		;set string pointer
	mov	xh	,r2

find_label_strcmp_loop:
	adiw	zh:zl	,1		;next char of label name
	lpm
	ldi	r17	,' '
	cp	r0	,r17
	breq	find_label_space_found

	ld	r17	,X+
	cp	r17	,r0
	brne	find_label_next			;wrong char, check next entry

	tst	r17			;check all chars until null char
	brne	find_label_strcmp_loop

find_label_space_found:
	ld	r17	,X+		;next char from command line
	tst	r17			;must be null byte
	brne	find_label_next			;wrong char, check next entry
	
find_label_found:
	set				;set status OK

	mov	zl	,yl		;load pointer into xh:xl
	mov	zh	,yh
	lpm
	mov	xl	,r0
	adiw	zh:zl	,1
	lpm
	mov	xh	,r0
	adiw	zh:zl	,1
	lpm
	mov	r16	,r0		;return label type from table
	rjmp	find_label_ok

find_label_exit:
	mov	xl	,r1
	mov	xh	,r2

find_label_ok:
	pop	zh
	pop	zl
	pop	r2
	pop	r1
	pop	r0	
	ret

;************************************************************
;	Monitor Labels
;************************************************************

.EQU	LABEL_LEN	= 10		;characters (+ ptr + type + nullbyte)
.EQU	L_BREG	= 0b00000001		;cpu byte register name (r0 - r31)
.EQU	L_WREG	= 0b00000010		;cpu word register name (x,y,z)
.EQU	L_IO	= 0b00000100		;i/o register name
.EQU	L_BRAM	= 0b00001000		;RAM address (variable)
.EQU	L_WRAM	= 0b00010000		;RAM address (variable)
.EQU	L_LRAM	= 0b00100000		;RAM address (variable)
.EQU	L_FRAM	= 0b01000000		;RAM address (variable)
.EQU	L_CMD	= 0b10000000		;subroutine
.EQU	L_END	= 0			;end of table

.EQU	IO_BASE	= 0x20

monitor_label_tab:

;************************************************************

	
	.dw	monitor_db
	.db	L_CMD	,"DB         "
	.dw	monitor_dw
	.db	L_CMD	,"DW         "
	.dw	monitor_dl
	.db	L_CMD	,"DL         "
	.dw	monitor_df
	.db	L_CMD	,"DF         "
	.dw	monitor_mb
	.db	L_CMD	,"MB         "
	.dw	monitor_mw
	.db	L_CMD	,"MW         "
	.dw	monitor_ml
	.db	L_CMD	,"ML         "
	.dw	monitor_mf
	.db	L_CMD	,"MF         "
	.dw	monitor_ports
	.db	L_CMD	,"PORTS      "
	.dw	0x0000
	.db	L_CMD	,"RESET      "

;************************************************************
;	CPU Registers and Ports
;************************************************************

	.dw	SPL + IO_BASE
	.db	L_WREG	,"SP         "
	.dw	GIMSK + IO_BASE
	.db	L_BREG	,"GIMSK      "
	.dw	GIFR + IO_BASE
	.db	L_BREG	,"GIFR       "
	.dw	TIMSK + IO_BASE
	.db	L_BREG	,"TIMSK      "
	.dw	TIFR + IO_BASE
	.db	L_BREG	,"TIFR       "
	.dw	MCUCR + IO_BASE
	.db	L_BREG	,"MCUCR      "
	.dw	PORTA + IO_BASE
	.db	L_BREG	,"PORTA      "
	.dw	DDRA + IO_BASE
	.db	L_BREG	,"DDRA       "
	.dw	PINA + IO_BASE
	.db	L_BREG	,"PINA       "
	.dw	PORTB + IO_BASE
	.db	L_BREG	,"PORTB      "
	.dw	DDRB + IO_BASE
	.db	L_BREG	,"DDRB       "
	.dw	PINB + IO_BASE
	.db	L_BREG	,"PINB       "
	.dw	PORTC + IO_BASE
	.db	L_BREG	,"PORTC      "
	.dw	DDRC + IO_BASE
	.db	L_BREG	,"DDRC       "
	.dw	PINC + IO_BASE
	.db	L_BREG	,"PINC       "
	.dw	PORTD + IO_BASE
	.db	L_BREG	,"PORTD      "
	.dw	DDRD + IO_BASE
	.db	L_BREG	,"DDRD       "
	.dw	PIND + IO_BASE
	.db	L_BREG	,"PIND       "

	.dw	0
	.db	L_END	, 0


;************************************************************

