
;****************************************************************************************
;Telescope Mount Controller III
;(c) Martin Cibulski
;
;EEPROM access routines
;
;based on application note AVR100 by Atmel
;***************************************************************************


.MACRO	e_readblock
	ldi	xh	,high(@0)
	ldi	xl	,low(@0)
	ldi	r16	,@1
	call	eep_read_block
.ENDMACRO

;****************************************************************************************

.ESEG


.EQU	E_NO_OF_PROFILES	= 4

eep_prof_default:
	.db	0			;simulator + z3 search

eep_profile_0:
	;simulator, z3 search
	.db	0x3E,0xD0,0xD2,0x24,0x5C,0x89,0xFD,0x63	;alg_az_per_step	4.0104e-6 = 2*PI/(153*4*40*64)
	.db	0x3E,0xD0,0xD2,0x24,0x5C,0x89,0xFD,0x63	;alg_alt_per_step	4.0104e-6 = 2*PI/(153*4*40*64)
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_alt_start	0.00
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z1
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z2
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z3
	.db	1			;alg_search_z3_yn
	.db	1			;mot_a_inverted
	.db	0			;mot_b_inverted

eep_profile_1:
	;14" scope, z3 search
	.db	0x3E,0x98,0x1D,0xB8,0x94,0x87,0x42,0x61	;alg_az_per_step	3.5935134843e-7	
	.db	0x3E,0x94,0xD2,0x95,0x32,0x2C,0x9B,0x41	;alg_alt_per_step	3.1028075591e-7
	.db	0x3F,0xEC,0x9F,0x97,0x1F,0xF8,0x4F,0xCD	;alg_alt_start	0,8944812416 = 51.25 degrees
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z1
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z2
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z3
	.db	1			;alg_search_z3_yn
	.db	1			;mot_a_inverted
	.db	0			;mot_b_inverted

	;simulator, no z3 search
	.db	0x3E,0xD0,0xD2,0x24,0x5C,0x89,0xFD,0x63	;alg_az_per_step	4.0104e-6 = 2*PI/(153*4*40*64)
	.db	0x3E,0xD0,0xD2,0x24,0x5C,0x89,0xFD,0x63	;alg_alt_per_step	4.0104e-6 = 2*PI/(153*4*40*64)
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_alt_start	0.00
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z1
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z2
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z3
	.db	0			;alg_search_z3_yn
	.db	1			;mot_a_inverted
	.db	0			;mot_b_inverted

	;14" scope, no z3 search
	.db	0x3E,0x98,0x1D,0xB8,0x94,0x87,0x42,0x61	;alg_az_per_step	3.5935134843e-7	
	.db	0x3E,0x94,0xD2,0x95,0x32,0x2C,0x9B,0x41	;alg_alt_per_step	3.1028075591e-7
	.db	0x3F,0xEC,0x9F,0x97,0x1F,0xF8,0x4F,0xCD	;alg_alt_start	0,8944812416 = 51.25 degrees
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z1
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z2
	.db	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;alg_z3
	.db	0			;alg_search_z3_yn
	.db	1			;mot_a_inverted
	.db	0			;mot_b_inverted

.EQU	E_PROFILE_SIZE	= eep_profile_1 - eep_profile_0

;****************************************************************************************
;Load Profile from EEPROM
;
;Parameters:
;r16	profile number	0 .. E_NO_OF_PROFILES-1
;****************************************************************************************

.CSEG
eep_load_profile:
	clt
	cpi	r16	,E_NO_OF_PROFILES
	brcc	eep_lpr_end			;return false

	ldi	zh	,high(eep_profile_0)
	ldi	zl	,low(eep_profile_0)
	ldi	r17	,E_PROFILE_SIZE
	mul	r16	,r17
	add	zl	,r0
	adc	zh	,r1
	e_readblock	mco_az_per_step	,8
	e_readblock	mco_alt_per_step	,8
	e_readblock	mco_alt_start	,8
	e_readblock	mco_z1	,8
	e_readblock	mco_z2	,8
	e_readblock	mco_z3	,8
	e_readblock	alg_search_z3_yn	,1
	e_readblock	mot_a_inverted	,1
	e_readblock	mot_b_inverted	,1
	set				;return true

eep_lpr_end:
	ret

;****************************************************************************************
;Write one byte into EEPROM
;
;Parameters:
;r16	byte
;zh:zl	EEPROM adress
;****************************************************************************************

.CSEG

eep_write:
	sbic	EECR	,EEWE		;if EEWE not clear
	rjmp	eep_write			;    wait more

	out 	EEARH	,zh		;output address high for 8515
	out	EEARL	,zl		;output address low for 8515

	out	EEDR	,r16		;output data
	cli
	sbi 	EECR	,EEMWE		;set master write enable, remove if 1200 is used	
	sbi	EECR	,EEWE		;set EEPROM Write strobe
					;This instruction takes 4 clock cycles since
					;it halts the CPU for two clock cycles
	sei
	ret

;****************************************************************************************
;Read one byte from EEPROM
;
;Parameters:
;zh:zl	EEPROM adress
;
;Result:
;r16	byte
;****************************************************************************************

eep_read:
	sbic	EECR	,EEWE		;if EEWE not clear
	rjmp	eep_read			;    wait more

	out 	EEARH	,zh		;output address high
	out	EEARL	,zl		;output address low

	sbi	EECR	,EERE		;set EEPROM Read strobe
					;This instruction takes 4 clock cycles since
					;it halts the CPU for two clock cycles
	in	r16	,EEDR		;get data
	ret

		
;****************************************************************************************
;Write RAM block (1-256 bytes) into EEPROM
;
;Parameters:
;r16	block size
;xh:xl	RAM start adress
;zh:zl	EEPROM start adress
;****************************************************************************************

eep_write_block:
	ld	r0	,X+

eep_wrb_wait:
	sbic	EECR,EEWE			;if EEWE not clear
	rjmp	eep_wrb_wait			;   wait more

	out 	EEARH	,zh		;output address high
	out	EEARL	,zl		;output address low
	out	EEDR	,r0		;output data
	cli
	sbi 	EECR	,EEMWE		;set master write enable
	sbi	EECR	,EEWE		;set EEPROM Write strobe
					;This instruction takes 4 clock cycles since
					;it halts the CPU for two clock cycles
	sei
	adiw	zh:zl	,1
	dec	r16
	brne	eep_write_block

	ret


;****************************************************************************************
;Read RAM block (1-256 bytes) from EEPROM
;
;Parameters:
;r16	block size
;zh:zl	EEPROM start adress
;xh:xl	RAM start adress
;****************************************************************************************

eep_read_block:
	sbic	EECR	,EEWE		;if EEWE not clear
	rjmp	eep_read_block			;   wait more

	out 	EEARH	,zh		;output address high
	out	EEARL	,zl		;output address low
	sbi	EECR	,EERE		;set EEPROM Read strobe
					;This instruction takes 4 clock cycles since
					;it halts the CPU for two clock cycles
	in	r0	,EEDR		;get data
	st	X+	,r0
	adiw	zh:zl	,1
	dec	r16
	brne	eep_read_block

	ret



;***********************************************************************
;Read RAM block (1-65535 bytes) from Program memory
;
;Parameters:
;r17:r16	Block size
;zh:zl	Program memory start adress (byte adress !)
;xh:xl	RAM start adress
;***********************************************************************

util_read_flash:
	push	r16
	push	r17

util_rdf_loop:
	lpm	r0	,Z+
	st	X+	,r0
	subi	r16	,1
	sbci	r17	,0
	brne	util_rdf_loop

	pop	r17
	pop	r16
	sub	zl	,r16
	sbc	zh	,r17
	sub	xl	,r16
	sbc	xh	,r17
	ret

;****************************************************************************************
