
;************************************************************
;IEEE 64 Bit Floating Point Library       (c) 2003 M.Cibulski
;
;Transcend Functions
;
;************************************************************


;************************************************************
;Exponential of Akku A
;
;AKKU = exp(AKKU)
;
;************************************************************

.CSEG
flt_exp:
	push	zl
	push	zh

	ldi	zl	,low(flt_exp_series << 1)
	ldi	zh	,high(flt_exp_series << 1)
	call	flt_powerseries

	pop	zh
	pop	zl
	ret

flt_exp_series:
	.DB	0x3C,0x62,0xF4,0x9B,0x46,0x81,0x41,0x57 ; 0.000000000000000008
	.DB	0x3C,0xA6,0x82,0x78,0x63,0xB9,0x7D,0x97 ; 0.000000000000000156
	.DB	0x3C,0xE9,0x52,0xC7,0x70,0x30,0xAD,0x4A ; 0.000000000000002811
	.DB	0x3D,0x2A,0xE7,0xF3,0xE7,0x33,0xB8,0x1F ; 0.000000000000047795
	.DB	0x3D,0x6A,0xE7,0xF3,0xE7,0x33,0xB8,0x1F ; 0.000000000000764716
	.DB	0x3D,0xA9,0x39,0x74,0xA8,0xC0,0x7C,0x9D ; 0.000000000011470746
	.DB	0x3D,0xE6,0x12,0x46,0x13,0xA8,0x6D,0x09 ; 0.000000000160590438
	.DB	0x3E,0x21,0xEE,0xD8,0xEF,0xF8,0xD8,0x98 ; 0.000000002087675699
	.DB	0x3E,0x5A,0xE6,0x45,0x67,0xF5,0x44,0xE4 ; 0.000000025052108385
	.DB	0x3E,0x92,0x7E,0x4F,0xB7,0x78,0x9F,0x5C ; 0.000000275573192240
	.DB	0x3E,0xC7,0x1D,0xE3,0xA5,0x56,0xC7,0x34 ; 0.000002755731922399
	.DB	0x3E,0xFA,0x01,0xA0,0x1A,0x01,0xA0,0x1A ; 0.000024801587301587
	.DB	0x3F,0x2A,0x01,0xA0,0x1A,0x01,0xA0,0x1A ; 0.000198412698412698
	.DB	0x3F,0x56,0xC1,0x6C,0x16,0xC1,0x6C,0x17 ; 0.001388888888888889
	.DB	0x3F,0x81,0x11,0x11,0x11,0x11,0x11,0x11 ; 0.008333333333333333
	.DB	0x3F,0xA5,0x55,0x55,0x55,0x55,0x55,0x55 ; 0.041666666666666664
	.DB	0x3F,0xC5,0x55,0x55,0x55,0x55,0x55,0x55 ; 0.166666666666666660
	.DB	0x3F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00 ; 0.500000000000000000
	.DB	0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00 ; 1.000000000000000000
	.DB	0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00 ; 1.000000000000000000
	.DB	0xFF,0xFF
 
;************************************************************
;Power series
;
;Parameters:
;Y:	Pointer to series constants
;
;Registers:
;AKKUA	floating point akkumulator
;AKKUB	temporary for RAM variable
;
;************************************************************

.CSEG
flt_powerseries:
	.EQU	flt_series_x	=  1
	.EQU	flt_series_lspace	=  9

	LOCAL	flt_series_lspace

	f_store_l	flt_series_x		;x = AKKU
	call	flt_load_z		;AKKU = *pArray++

flt_series_loop:
	lpm			;check for 0xFF (end of array)
	inc	r0
	breq	flt_series_end

	f_push			;AKKU = AKKU * x + *pArray++
	f_load_l	flt_series_x
	f_mul
	f_push
	call	flt_load_z
	f_add
	rjmp	flt_series_loop
		
flt_series_end:
	ENDLOCAL	flt_series_lspace
	ret

