
;************************************************************
;IEEE 64 Bit Floating Point Library       (c) 2003 M.Cibulski
;
;Test Routines
;
;************************************************************



.CSEG
flt_test:
	;rcall	flt_test_prt
	rcall	flt_test_add
	rcall	flt_test_sub
	rcall	flt_test_mul
	rcall	flt_test_div

	rcall	flt_test_floor

	rcall	flt_test_sqrt
	rcall	flt_test_atan
	rcall	flt_test_atan2
	rcall	flt_test_sin
	rcall	flt_test_cos

	ret

;************************************************************

flt_label_tab:	
	.dw	monitor_flt_nop
	.db	L_CMD	,"FNOP       "
	.dw	monitor_flt_add
	.db	L_CMD	,"ADD        "
	.dw	monitor_flt_sub
	.db	L_CMD	,"SUB        "
	.dw	monitor_flt_mul
	.db	L_CMD	,"MUL        "
	.dw	monitor_flt_div
	.db	L_CMD	,"DIV        "
	.dw	monitor_flt_atan2
	.db	L_CMD	,"ATAN2      "
	.dw	monitor_flt_sin
	.db	L_CMD	,"SIN        "
	.dw	monitor_flt_cos
	.db	L_CMD	,"COS        "
	.dw	monitor_flt_atan
	.db	L_CMD	,"ATAN       "
	.dw	monitor_flt_sqrt
	.db	L_CMD	,"SQRT       "

	.dw	0
	.db	L_END	, 0


;************************************************************

;************************************************************

.DSEG
monitor_flt_X:
	.byte	8
monitor_flt_Y:
	.byte	8
monitor_flt_Z:
	.byte	8

.CSEG
monitor_flt_nop:
	rcall	monitor_flt_getx
	brtc	monitor_flt_nop_exit

	ldi	xl	,low(monitor_flt_X)
	ldi	xh	,high(monitor_flt_X)
	jmp	monitor_df_print

monitor_flt_nop_exit:
	ret

monitor_flt_add:
	rcall	monitor_flt_getxy
	brtc	monitor_flt_add_exit

	f_load	monitor_flt_X
	f_push
	f_load	monitor_flt_Y
	f_add
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_add_exit:
	ret

monitor_flt_sub:
	rcall	monitor_flt_getxy
	brtc	monitor_flt_sub_exit

	f_load	monitor_flt_X
	f_push
	f_load	monitor_flt_Y
	f_sub
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_sub_exit:
	ret

monitor_flt_mul:
	rcall	monitor_flt_getxy
	brtc	monitor_flt_mul_exit

	f_load	monitor_flt_X
	f_push
	f_load	monitor_flt_Y
	f_mul
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_mul_exit:
	ret

monitor_flt_div:
	rcall	monitor_flt_getxy
	brtc	monitor_flt_div_exit

	f_load	monitor_flt_X
	f_push
	f_load	monitor_flt_Y
	f_div
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_div_exit:
	ret

monitor_flt_atan2:
	rcall	monitor_flt_getxy
	brtc	monitor_flt_atan2_exit

	f_load	monitor_flt_X
	f_push
	f_load	monitor_flt_Y
	f_atan2
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_atan2_exit:
	ret

monitor_flt_sin:
	rcall	monitor_flt_getx
	brtc	monitor_flt_sin_exit

	f_load	monitor_flt_X
	f_sin
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_sin_exit:
	ret

monitor_flt_cos:
	rcall	monitor_flt_getx
	brtc	monitor_flt_cos_exit

	f_load	monitor_flt_X
	f_cos
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_cos_exit:
	ret

monitor_flt_atan:
	rcall	monitor_flt_getx
	brtc	monitor_flt_atan_exit

	f_load	monitor_flt_X
	f_atan
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_atan_exit:
	ret

monitor_flt_sqrt:
	rcall	monitor_flt_getx
	brtc	monitor_flt_sqrt_exit

	f_load	monitor_flt_X
	f_sqrt
	f_store	monitor_flt_Z
	ldi	xl	,low(monitor_flt_Z)
	ldi	xh	,high(monitor_flt_Z)
	jmp	monitor_df_print

monitor_flt_sqrt_exit:
	ret


monitor_flt_getxy:
	clt

	call	next_flt_value
	brtc	monitor_flt_getxy_exit

	f_store	monitor_flt_X
	call	next_flt_value
	brtc	monitor_flt_getxy_exit

	f_store	monitor_flt_Y
	set

monitor_flt_getxy_exit:
	ret

monitor_flt_getx:
	clt

	call	next_flt_value
	brtc	monitor_flt_getx_exit

	ldi	xl	,low(monitor_flt_X)
	ldi	xh	,high(monitor_flt_X)
	f_store	monitor_flt_X
	set

monitor_flt_getx_exit:
	ret



;************************************************************
;IEEE 64 Bit Floating Point Library       (c) 2003 M.Cibulski
;
;Test Routines
;
;************************************************************

prt__test_data:
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0xC0,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	;-12.123
	.DB	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;  0.000

	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x40,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	;  5.123
	.DB	0x40,0x31,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 17.246

	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x40,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	;  7.000

	.DB	0x40,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	;  5.123
	.DB	0xC0,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	;-12.123
	.DB	0xC0,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	; -7.000

	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x40,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	;  7.000

	.DB	0xC0,0x11,0x54,0xFD,0xF3,0xB6,0x45,0xA2	; -4.333
	.DB	 0xC0,0x19,0xBB,0x64,0x5A,0x1C,0xAC,0x08	; -6.433
	.DB	0xC0,0x25,0x88,0x31,0x26,0xE9,0x78,0xD5	;-10.766

	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x40,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	;  7.000

	.DB	0xFF,0xFF

flt_test_prt:
	ldi	zl	,low(prt__test_data << 1)
	ldi	zh	,high(prt__test_data << 1)

flt_test_prt_loop:
	lpm
	ldi	r16	,0xFF
	cp	r0	,r16
	breq	flt_test_prt_exit

	call	flt_load_z
	call	flt_print
	ldi	xh	,high(putc_buf)
	ldi	xl	,low(putc_buf)
	call	flt_atof_x
	rjmp	flt_test_prt_loop

flt_test_prt_exit:
	ret


;************************************************************
;putc	Print one character into memory
;
;Parameters
;r16	ASCII code of character to print
;
;Results	-
;
;Globals
;putc_buf	string buffer
;putc_ptr	buffer pointer (high byte first)
;
;Stack	2+2=4 bytes
;
;2002-02-14	first version (buffer overflow possible)
;************************************************************

.EQU	putc_size	= 32

.DSEG
putc_buf:	.BYTE	putc_size			;buffer for characters
putc_ptr:	.BYTE	2			;buffer pointer
	
.CSEG
_putc:
	push	xl			;save X
	push	xh

	lds	xh	,putc_ptr		;*pointer++ = character
	lds	xl	,putc_ptr+1
	st	X+	,r16
	sts	putc_ptr	,xh
	sts	putc_ptr+1	,xl

	pop	xh			;restore X
	pop	xl
	ret


;************************************************************
;putc_init	Initialize string buffer
;
;Parameters	-
;
;Results	-
;
;Globals
;putc_buf	string buffer
;putc_ptr	buffer pointer (high byte first)
;
;Stack	4+2=6 bytes
;
;2002-02-14	first version
;************************************************************

_putc_init:
	push	r16
	push	r17
	push	xl
	push	xh

	ldi	xl	,low(putc_buf)	;set pointer to start of buffer
	ldi	xh	,high(putc_buf)
	sts	putc_ptr	,xh
	sts	putc_ptr+1	,xl

	ldi	r16	,putc_size
	ldi	r17	,' '

_putc_init_loop:
	st	X+	,r17		;fill buffer with spaces
	dec	r16
	brne	_putc_init_loop

	pop	xh
	pop	xl
	pop	r17
	pop	r16
	ret


;************************************************************

add__test_data:
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0xC0,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	;-12.123
	.DB	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;  0.000

	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x40,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	;  5.123
	.DB	0x40,0x31,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 17.246

	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x40,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	;  7.000

	.DB	0x40,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	;  5.123
	.DB	0xC0,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	;-12.123
	.DB	0xC0,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	; -7.000

	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x40,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	;  7.000

	.DB	0xC0,0x11,0x54,0xFD,0xF3,0xB6,0x45,0xA2	; -4.333
	.DB	 0xC0,0x19,0xBB,0x64,0x5A,0x1C,0xAC,0x08	; -6.433
	.DB	0xC0,0x25,0x88,0x31,0x26,0xE9,0x78,0xD5	;-10.766

	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x40,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	;  7.000

	.DB	0xFF,0xFF

flt_test_add:
	ldi	zl	,low(add__test_data << 1)
	ldi	zh	,high(add__test_data << 1)

flt_test_add_loop:
	lpm
	ldi	r16	,0xFF
	cp	r0	,r16
	breq	flt_test_add_exit

	call	flt_load_z
	f_push
	call	flt_load_z
	f_add
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_test_add_loop

	f_debug

flt_test_add_exit:
	ret

;************************************************************

sub__test_data:
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;  0.000

	.DB	0x40,0x31,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 17.246
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0x40,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCA	;  5.123

	.DB	0x40,0x1C,0x00,0x00,0x00,0x00,0x00,0x00	;  7.000
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	; 12.123
	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCA	; -5.123

	.DB	0xC0,0x1C,0x00,0x00,0x00,0x00,0x00,0x00	; -7.000
	.DB	0x40,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	;  5.123
	.DB	0xC0,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE6	;-12.123

	.DB	0x40,0x1B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF	;  7.000
	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x40,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE6	; 12.123

	.DB	0xC0,0x25,0x88,0x31,0x26,0xE9,0x78,0xD5	;-10.766
	.DB	0xC0,0x11,0x54,0xFD,0xF3,0xB6,0x45,0xA2	; -4.333
	.DB	0xC0,0x19,0xBB,0x64,0x5A,0x1C,0xAC,0x08	; -6.433

	.DB	0xFF,0xFF

flt_test_sub:
	ldi	zl	,low(sub__test_data << 1)
	ldi	zh	,high(sub__test_data << 1)

flt_test_sub_loop:
	lpm
	ldi	r16	,0xFF
	cp	r0	,r16
	breq	flt_test_sub_exit

	call	flt_load_z
	f_push
	call	flt_load_z
	f_sub
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_test_sub_loop

	f_debug

flt_test_sub_exit:
	ret

;************************************************************

mul__test_data:
	.DB	0x3F,0xF3,0xC0,0x83,0x12,0x6E,0x97,0x8D	;  1.2345
	.DB	0x3F,0xFB,0xED,0xFA,0x43,0xFE,0x5C,0x92	;  1.7456
	.DB	0x40,0x01,0x3D,0x52,0xDC,0x45,0xE6,0x94	;  2.1549432

	.DB	0xC0,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	;-12.123
	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x40,0x4F,0x0D,0x95,0xA2,0x94,0x14,0x1E	;62.106129

	.DB	0xFF,0xFF

flt_test_mul:
	ldi	zl	,low(mul__test_data << 1)
	ldi	zh	,high(mul__test_data << 1)

flt_test_mul_loop:
	lpm
	ldi	r16	,0xFF
	cp	r0	,r16
	breq	flt_test_mul_exit

	call	flt_load_z
	f_push
	call	flt_load_z
	f_mul
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_test_mul_loop

	f_debug

flt_test_mul_exit:
	ret

;************************************************************

div__test_data:
	.DB	0x3F,0xF0,0x00,0x01,0x00,0x00,0x00,0x00	;  1.0000*
	.DB	0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00	;  1.0000
	.DB	0x3F,0xF0,0x00,0x01,0x00,0x00,0x00,0x00	;  1.0000*

	.DB	0x40,0x4F,0x0D,0x95,0xA2,0x94,0x14,0x1E	;62.106129
	.DB	0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00	;  1.0000
	.DB	0x40,0x4F,0x0D,0x95,0xA2,0x94,0x14,0x1E	;62.106129

	.DB	0x40,0x4F,0x0D,0x95,0xA2,0x94,0x14,0x1F	;62.106129
	.DB	0xC0,0x28,0x3E,0xF9,0xDB,0x22,0xD0,0xE5	;-12.123
	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123

	.DB	0xFF,0xFF

flt_test_div:
	ldi	zl	,low(div__test_data << 1)
	ldi	zh	,high(div__test_data << 1)

flt_test_div_loop:
	lpm
	ldi	r16	,0xFF
	cp	r0	,r16
	breq	flt_test_div_exit

	call	flt_load_z
	f_push
	call	flt_load_z
	f_div
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_test_div_loop

	f_debug

flt_test_div_exit:
	ret

;************************************************************

sqrt__test_data:
	.DB	0x3f,0xd0,0x00,0x00,0x00,0x00,0x00,0x00	;  0.25
	.DB	0x3f,0xe0,0x00,0x00,0x00,0x00,0x00,0x00	;  0.5

	.DB	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;  0.000
	.DB	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;  0.000

	.DB	0xC0,0x14,0x7D,0xF3,0xB6,0x45,0xA1,0xCB	; -5.123
	.DB	0x7F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00	; NAN

	.DB	0x40,0x5E,0xE0,0x00,0x00,0x00,0x00,0x00	;123.5
	.DB	0x40,0x26,0x39,0xE2,0x65,0x3E,0x42,0x1B	; 11.113055385446435 

	.DB	0xFF,0xFF

flt_test_sqrt:
	ldi	zl	,low(sqrt__test_data << 1)
	ldi	zh	,high(sqrt__test_data << 1)

flt_test_sqrt_loop:
	lpm
	ldi	r16	,0xFF
	cp	r0	,r16
	breq	flt_test_sqrt_exit

	call	flt_load_z
	f_sqrt
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_test_sqrt_loop

	f_debug

flt_test_sqrt_exit:
	ret

;************************************************************

flt_atan_test_data:

	.DB	0x40,0x04,0x00,0x00,0x00,0x00,0x00,0x00	;2.5
	.DB	0x3F,0xF3,0x0B,0x6D,0x79,0x6A,0x4D,0xA8	;1.1902899496825317

	.DB	0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00	;1
	.DB	0x3F,0xE9,0x21,0xFB,0x54,0x44,0x2D,0x18	;0.78539816339744828

	.DB	0x3F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00	;0.5
	.DB	0x3F,0xDD,0xAC,0x67,0x05,0x61,0xBB,0x4F	;0.46364760900080609

	.DB	0xBF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00	;-0.5
	.DB	0xBF,0xDD,0xAC,0x67,0x05,0x61,0xBB,0x4F	;0.46364760900080609

	.DB	0xFF,0xFF

flt_test_atan:
	ldi	zl	,low(flt_atan_test_data << 1)
	ldi	zh	,high(flt_atan_test_data << 1)

flt_atan_test_loop:
	lpm
	inc	r0
	breq	flt_atan_test_exit

	call	flt_load_z
	f_atan
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_atan_test_loop

	f_debug

flt_atan_test_exit:

	ret

;************************************************************

flt_atan2_test_data:

	.DB	0x40,0x04,0x00,0x00,0x00,0x00,0x00,0x00	;2.5
	.DB	0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00	;1
	.DB	0x3F,0xF3,0x0B,0x6D,0x79,0x6A,0x4D,0xA8	;1.1902899496825317

	.DB	0xFF,0xFF

flt_test_atan2:
	ldi	zl	,low(flt_atan2_test_data << 1)
	ldi	zh	,high(flt_atan2_test_data << 1)

flt_atan2_test_loop:
	lpm
	inc	r0
	breq	flt_atan2_test_exit

	call	flt_load_z
	f_push
	call	flt_load_z
	f_atan2
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_atan2_test_loop

	f_debug

flt_atan2_test_exit:

	ret

;************************************************************

flt_floor_test_data:

	.DB	0x40,0x12,0x00,0x00,0x00,0x00,0x00,0x00	;4.5
    	.DB	0x40,0x10,0x00,0x00,0x00,0x00,0x00,0x00	;4

	.DB	0x3F,0xE1,0x99,0x99,0x99,0x99,0x99,0x9A	;0.55
	.DB	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;0

	.DB	0xC0,0x12,0x00,0x00,0x00,0x00,0x00,0x00	;-4.5
    	.DB	0xC0,0x14,0x00,0x00,0x00,0x00,0x00,0x00	;-5

	.DB	0xC0,0x12,0x00,0x00,0x00,0x00,0x00,0x00	;-4.5
    	.DB	0xC0,0x14,0x00,0x00,0x00,0x00,0x00,0x00	;-5

	.DB	0xBF,0xE1,0x99,0x99,0x99,0x99,0x99,0x9A	;-0.55
	.DB	0xBF,0xF0,0x00,0x00,0x00,0x00,0x00,0x00	;-1

	.DB	0xFF,0xFF

flt_test_floor:
	ldi	zl	,low(flt_floor_test_data << 1)
	ldi	zh	,high(flt_floor_test_data << 1)

flt_floor_test_loop:
	lpm
	inc	r0
	breq	flt_floor_test_exit

	call	flt_load_z
	f_floor
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_floor_test_loop

	f_debug

flt_floor_test_exit:

	ret

;************************************************************

flt_sin_test_data:
	.DB	0x40,0x8F,0x40,0x00,0x00,0x00,0x00,0x00	;1000
	.DB	0x3F,0xEA,0x75,0xCC,0x15,0x0A,0x20,0x6B	;0.82687954053200252

	.DB	0xC0,0x28,0x00,0x00,0x00,0x00,0x00,0x00	;-12
	.DB	0x3F,0xE1,0x2B,0x9A,0xF7,0xD7,0x65,0xA5	;0.53657291800043494

	.DB	0x3F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00	;0.5
 	.DB	0x3F,0xDE,0xAE,0xE8,0x74,0x4B,0x05,0xF0	;0.47942553860420301

	.DB	0x3F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00	;1
	.DB	0x3F,0xEA,0xED,0x54,0x8F,0x09,0x0C,0xEE	;0.8414709848078965 

	.DB	0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00	;2
	.DB	0x3F,0xED,0x18,0xF6,0xEA,0xD1,0xB4,0x46	;0.90929742682568171

	.DB	0x40,0x08,0x00,0x00,0x00,0x00,0x00,0x00	;3
	.DB	0x3F,0xC2,0x10,0x38,0x6D,0xB6,0xD5,0x5B	;0.14112000805986721 


	.DB	0xFF,0xFF

flt_test_sin:
	ldi	zl	,low(flt_sin_test_data << 1)
	ldi	zh	,high(flt_sin_test_data << 1)

flt_sin_test_loop:
	lpm
	inc	r0
	breq	flt_sin_test_exit

	call	flt_load_z
	f_sin
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_sin_test_loop

	f_debug

flt_sin_test_exit:

	ret
;************************************************************

flt_cos_test_data:
	.DB	0xFF,0xFF

flt_test_cos:
	ldi	zl	,low(flt_cos_test_data << 1)
	ldi	zh	,high(flt_cos_test_data << 1)

flt_cos_test_loop:
	lpm
	inc	r0
	breq	flt_cos_test_exit

	call	flt_load_z
	f_cos
	f_push
	call	flt_load_z
	f_x_eq_y
	f_pop
	brts	flt_cos_test_loop

	f_debug

flt_cos_test_exit:

	ret

;************************************************************
