
;************************************************************
;IEEE 64 Bit Floating Point Library       (c) 2003 M.Cibulski
;
;Transfer Functions
;
;************************************************************


;************************************************************
;UPN Enter
;Push Akku on the stack
;
;Parameters:
;
;Registers:
;AKKU	floating point akkumulator A
;
;************************************************************

.CSEG
flt_push:
	pop	r0
	pop	r1

	push	AKKU_8
	push	AKKU_7
	push	AKKU_6
	push	AKKU_5
	push	AKKU_4
	push	AKKU_3
	push	AKKU_2
	push	AKKU_E2
	push	AKKU_E1
	push	AKKU_S

	push	r1
	push	r0
	ret

;************************************************************
;UPN Pop
;Pop Y from stack into Akku
;
;Parameters:
;
;Registers:
;AKKU	floating point akkumulator A
;
;************************************************************

.CSEG
flt_pop:
	pop	r0
	pop	r1

	pop	AKKU_S
	pop	AKKU_E1
	pop	AKKU_E2
	pop	AKKU_2
	pop	AKKU_3
	pop	AKKU_4
	pop	AKKU_5
	pop	AKKU_6
	pop	AKKU_7
	pop	AKKU_8

	push	r1
	push	r0
	ret

;************************************************************
;Exchange X (Akku) and Y
;
;Parameters:
;
;Registers:
;AKKU	floating point akkumulator A
;
;************************************************************

.CSEG
flt_xy:
	in	xl	,spl
	in	xh	,sph
	adiw	xh:xl	,3

	ld	r0	,X
	st	X+	,AKKU_S
	mov	AKKU_S	,r0
	ld	r0	,X
	st	X+	,AKKU_E1
	mov	AKKU_E1	,r0
	ld	r0	,X
	st	X+	,AKKU_E2
	mov	AKKU_E2	,r0
	ld	r0	,X
	st	X+	,AKKU_2
	mov	AKKU_2	,r0
	ld	r0	,X
	st	X+	,AKKU_3
	mov	AKKU_3	,r0
	ld	r0	,X
	st	X+	,AKKU_4
	mov	AKKU_4	,r0
	ld	r0	,X
	st	X+	,AKKU_5
	mov	AKKU_5	,r0
	ld	r0	,X
	st	X+	,AKKU_6
	mov	AKKU_6	,r0
	ld	r0	,X
	st	X+	,AKKU_7
	mov	AKKU_7	,r0
	ld	r0	,X
	st	X+	,AKKU_8
	mov	AKKU_8	,r0

	ret

;************************************************************
;Load RAM Variable into Akku A
;
;Parameters:
;X:	Pointer to variable
;
;Registers:
;AKKU	floating point akkumulator
;
;************************************************************


.CSEG
flt_load_x:
	ld	AKKU_S	,X+		;sign and exp bits 10-4
	ld	AKKU_2	,X+		;exp bits 3-0, mant bits 51-48
	ld	AKKU_3	,X+
	ld	AKKU_4	,X+
	ld	AKKU_5	,X+
	ld	AKKU_6	,X+
	ld	AKKU_7	,X+
	ld	AKKU_8	,X+
	rjmp	_flt_load

;************************************************************
;Load Zero into Akku
;
;AKKU = 0.0
;
;************************************************************

.CSEG
flt_zero:
	clr	AKKU_S
	clr	AKKU_E1
	clr	AKKU_E2
	clr	AKKU_2
	clr	AKKU_3
	clr	AKKU_4
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8
	ret

;************************************************************
;Load Constant from Program Memory into Akku A
;
;Parameters:
;Z:	Pointer to constant, will be incremented by 8
;	AKKU = *Z++
;
;Registers:
;AKKU	floating point akkumulator A
;
;************************************************************

.CSEG
flt_load_z:
	lpm	AKKU_S	,Z+		;sign and exp bits 10-4
	lpm	AKKU_2	,Z+		;exp bits 3-0, mant bits 51-48
	lpm	AKKU_3	,Z+
	lpm	AKKU_4	,Z+
	lpm	AKKU_5	,Z+
	lpm	AKKU_6	,Z+
	lpm	AKKU_7	,Z+
	lpm	AKKU_8	,Z+

_flt_load:
	mov	r16	,AKKU_S
	or	r16	,AKKU_2
	breq	flt_load_zero

	mov	r16	,AKKU_S
	andi	r16	,0x7F
	cpi	r16	,0x7F
	brne	flt_load_01

	mov	r16	,AKKU_2
	andi	r16	,0xF0
	cpi	r16	,0xF0
	breq	flt_load_nan

flt_load_01:

	mov	AKKU_E1	,AKKU_S

	ldi	r16	,0b10000000
	and	AKKU_S	,r16		;sign

	mov	AKKU_E2	,AKKU_E1
	swap	AKKU_E2
	ldi	r16	,0b11110000
	and	AKKU_E2	,r16		;exp bits 7,6,5,4
	swap	AKKU_E1
	ldi	r16	,0b00000111
	and	AKKU_E1	,r16		;exp bits  10,9,8

	mov	r16	,AKKU_2
	swap	r16
	andi	r16	,0b00001111
	or	AKKU_E2	,r16		;exp bits 3,2,1,0

	ldi	r16	,0b00001111
	and	AKKU_2	,r16
	ldi	r16	,0b00010000
	or	AKKU_2	,r16

	ret

flt_load_zero:
	clr	AKKU_S
	clr	AKKU_E1
	clr	AKKU_E2
	clr	AKKU_2
	clr	AKKU_3
	clr	AKKU_4
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8
	ret

flt_load_nan:
	clr	AKKU_S
	ldi	r16	,0x07
	mov	AKKU_E1	,r16
	ldi	r16	,0xFF
	mov	AKKU_E2	,r16
	clr	AKKU_2
	clr	AKKU_3
	clr	AKKU_4
	clr	AKKU_5
	clr	AKKU_6
	clr	AKKU_7
	clr	AKKU_8
	ret


;************************************************************
;Store Akku into RAM Variable
;
;Parameters:
;X:	Pointer to variable
;
;Registers:
;AKKU	floating point akkumulator
;
;************************************************************


.CSEG
flt_store_x:
	mov	r16	,AKKU_E2
	andi	r16	,0b11110000
	swap	r16
	mov	r17	,AKKU_E1
	andi	r17	,0b00000111
	swap	r17
	or	r16	,r17
	or	r16	,AKKU_S
	st	X+	,r16

	mov	r16	,AKKU_E2
	swap	r16
	andi	r16	,0b11110000
	mov	r17	,AKKU_2
	andi	r17	,0b00001111
	or	r16	,r17
	st	X+	,r16

	st	X+	,AKKU_3
	st	X+	,AKKU_4
	st	X+	,AKKU_5
	st	X+	,AKKU_6
	st	X+	,AKKU_7
	st	X+	,AKKU_8
	ret


;************************************************************
;************************************************************
