

;*****************************************************************************************
;	Mega 128 Scope Controller Program
;	(c) Martin Cibulski
;*****************************************************************************************


;*****************************************************************************************
;	Stepper Motor Datasets
.DSEG

mot:
mot_min_pwm:	.byte	1

mot_a:
mot_a_ph_1:	.byte	1		;phase of coil 1
mot_a_ph_2:	.byte	1		;phase of coil 2
mot_a_pwmper:	.byte	2		;PWM period
mot_a_pwmfac:	.byte	1		;factor for PWM on-time
mot_a_pwmmin:	.byte	2		;minimum PWM on-time

mot_a_pos:	.byte	6		;position
mot_a_sp:	.byte	4		;speed
mot_a_gsp:	.byte	4		;tracking/goto speed
mot_a_acc:	.byte	4		;acceleration
mot_a_ssp:	.byte	4		;speed setpoints
mot_a_ssp1:	.byte	4
mot_a_ssp2:	.byte	4
mot_a_ssp3:	.byte	4
mot_a_ssp4:	.byte	4
mot_a_ssp5:	.byte	4
mot_a_msmax:	.byte	4
mot_a_hsmode:	.byte	1
mot_a_inverted:	.byte	1

mot_b:
mot_b_ph_1:	.byte	1		;phase of coil 1
mot_b_ph_2:	.byte	1		;phase of coil 2
mot_b_pwmper:	.byte	2		;PWM period
mot_b_pwmfac:	.byte	1		;factor for PWM on-time
mot_b_pwmmin:	.byte	2		;minimum PWM on-time

mot_b_pos:	.byte	6		;position
mot_b_sp:	.byte	4		;speed
mot_b_gsp:	.byte	4		;tracking/goto speed
mot_b_acc:	.byte	4		;acceleration
mot_b_ssp:	.byte	4		;speed setpoints
mot_b_ssp1:	.byte	4
mot_b_ssp2:	.byte	4
mot_b_ssp3:	.byte	4
mot_b_ssp4:	.byte	4
mot_b_ssp5:	.byte	4
mot_b_msmax:	.byte	4
mot_b_hsmode:	.byte	1
mot_b_inverted:	.byte	1

;*****************************************************************************************
;Variables in Datasets

.EQU	MOT_PH1	= (mot_a_ph_1-mot_a)	;1 byte
.EQU	MOT_PH2	= (mot_a_ph_2-mot_a)	;1 byte
.EQU	MOT_PWMPER	= (mot_a_pwmper-mot_a)	;2 bytes
.EQU	MOT_PWMFAC	= (mot_a_pwmfac-mot_a)	;1 byte
.EQU	MOT_PWMMIN	= (mot_a_pwmmin-mot_a)	;1 byte
.EQU	MOT_POS	= (mot_a_pos-mot_a)	;6 bytes
.EQU	MOT_SP	= (mot_a_sp-mot_a)	;4 bytes
.EQU	MOT_GSP	= (mot_a_gsp-mot_a)	;4 bytes
.EQU	MOT_ACC	= (mot_a_acc-mot_a)	;4 bytes
.EQU	MOT_SSP	= (mot_a_ssp-mot_a)	;4 bytes
.EQU	MOT_SSP1	= (mot_a_ssp1-mot_a)	;4 bytes
.EQU	MOT_SSP2	= (mot_a_ssp2-mot_a)	;4 bytes
.EQU	MOT_SSP3	= (mot_a_ssp3-mot_a)	;4 bytes
.EQU	MOT_SSP4	= (mot_a_ssp4-mot_a)	;4 bytes
.EQU	MOT_SSP5	= (mot_a_ssp5-mot_a)	;4 bytes
.EQU	MOT_MSMAX	= (mot_a_msmax-mot_a)	;4 bytes
.EQU	MOT_HSMODE	= (mot_a_hsmode-mot_a)	;1 byte
.EQU	MOT_INVERTED	= (mot_a_inverted-mot_a)	;1 byte

.CSEG
mot_label_tab:
	.dw	mot_a_pos
	.db	L_LRAM	,"MOTAPOS    "
	.dw	mot_a_sp
	.db	L_LRAM	,"MOTASP     "
	.dw	mot_a_gsp
	.db	L_LRAM	,"MOTAGSP    "
	.dw	mot_a_ssp
	.db	L_LRAM	,"MOTASSP    "
	.dw	mot_a_ssp1
	.db	L_LRAM	,"MOTASSP1   "
	.dw	mot_a_ssp2
	.db	L_LRAM	,"MOTASSP2   "
	.dw	mot_a_ssp3
	.db	L_LRAM	,"MOTASSP3   "
	.dw	mot_a_ssp4
	.db	L_LRAM	,"MOTASSP4   "
	.dw	mot_a_ssp5
	.db	L_LRAM	,"MOTASSP5   "
	.dw	mot_a_acc
	.db	L_LRAM	,"MOTAACC    "
	.dw	mot_a_pwmper
	.db	L_WRAM	,"MOTAPWMPER "
	.dw	mot_a_pwmfac
	.db	L_BRAM	,"MOTAPWMFAC "
	.dw	mot_a_pwmmin
	.db	L_WRAM	,"MOTAPWMMIN "
	.dw	mot_a_msmax
	.db	L_LRAM	,"MOTAMSMAX  "
	.dw	mot_a_inverted
	.db	L_BRAM	,"MOTAINVERT "

	.dw	mot_b_pos
	.db	L_LRAM	,"MOTBPOS    "
	.dw	mot_b_sp
	.db	L_LRAM	,"MOTBSP     "
	.dw	mot_b_gsp
	.db	L_LRAM	,"MOTBGSP    "
	.dw	mot_b_ssp
	.db	L_LRAM	,"MOTBSSP    "
	.dw	mot_b_ssp1
	.db	L_LRAM	,"MOTBSSP1   "
	.dw	mot_b_ssp2
	.db	L_LRAM	,"MOTBSSP2   "
	.dw	mot_b_ssp3
	.db	L_LRAM	,"MOTBSSP3   "
	.dw	mot_b_ssp4
	.db	L_LRAM	,"MOTBSSP4   "
	.dw	mot_b_ssp5
	.db	L_LRAM	,"MOTBSSP5   "
	.dw	mot_b_acc
	.db	L_LRAM	,"MOTBACC    "
	.dw	mot_b_pwmper
	.db	L_WRAM	,"MOTBPWMPER "
	.dw	mot_b_pwmfac
	.db	L_BRAM	,"MOTBPWMFAC "
	.dw	mot_b_pwmmin
	.db	L_WRAM	,"MOTBPWMMIN "
	.dw	mot_b_msmax
	.db	L_LRAM	,"MOTBMSMAX  "
	.dw	mot_b_inverted
	.db	L_BRAM	,"MOTBINVERT "

	.dw	0
	.db	L_END	, 0

;*****************************************************************************************
;	Stepper Motor Calculations
;	called from the keypad routine
;
;Parameters	yh:yl	adress of motor data block

.CSEG

mot_speed_null:
	clr	r16
	clr	r17
	clr	r18
	clr	r19
	rjmp	mot_speed

mot_speed_plus5:
	ldd	r16	,Y+MOT_SSP5
	ldd	r17	,Y+MOT_SSP5+1
	ldd	r18	,Y+MOT_SSP5+2
	ldd	r19	,Y+MOT_SSP5+3
	rjmp	mot_speed

mot_speed_minus5:
	clr	r16
	clr	r17
	clr	r18
	clr	r19
	ldd	r20	,Y+MOT_SSP5+3
	sub	r19	,r20
	ldd	r20	,Y+MOT_SSP5+2
	sbc	r18	,r20
	ldd	r20	,Y+MOT_SSP5+1
	sbc	r17	,r20
	ldd	r20	,Y+MOT_SSP5
	sbc	r16	,r20
	rjmp	mot_speed

mot_speed_plus4:
	ldd	r16	,Y+MOT_SSP4
	ldd	r17	,Y+MOT_SSP4+1
	ldd	r18	,Y+MOT_SSP4+2
	ldd	r19	,Y+MOT_SSP4+3
	rjmp	mot_speed

mot_speed_minus4:
	clr	r16
	clr	r17
	clr	r18
	clr	r19
	ldd	r20	,Y+MOT_SSP4+3
	sub	r19	,r20
	ldd	r20	,Y+MOT_SSP4+2
	sbc	r18	,r20
	ldd	r20	,Y+MOT_SSP4+1
	sbc	r17	,r20
	ldd	r20	,Y+MOT_SSP4
	sbc	r16	,r20
	rjmp	mot_speed

mot_speed_plus3:
	ldd	r16	,Y+MOT_SSP3
	ldd	r17	,Y+MOT_SSP3+1
	ldd	r18	,Y+MOT_SSP3+2
	ldd	r19	,Y+MOT_SSP3+3
	rjmp	mot_speed

mot_speed_minus3:
	clr	r16
	clr	r17
	clr	r18
	clr	r19
	ldd	r20	,Y+MOT_SSP3+3
	sub	r19	,r20
	ldd	r20	,Y+MOT_SSP3+2
	sbc	r18	,r20
	ldd	r20	,Y+MOT_SSP3+1
	sbc	r17	,r20
	ldd	r20	,Y+MOT_SSP3
	sbc	r16	,r20
	rjmp	mot_speed

mot_speed_plus2:
	ldd	r16	,Y+MOT_SSP2
	ldd	r17	,Y+MOT_SSP2+1
	ldd	r18	,Y+MOT_SSP2+2
	ldd	r19	,Y+MOT_SSP2+3
	rjmp	mot_speed

mot_speed_minus2:
	clr	r16
	clr	r17
	clr	r18
	clr	r19
	ldd	r20	,Y+MOT_SSP2+3
	sub	r19	,r20
	ldd	r20	,Y+MOT_SSP2+2
	sbc	r18	,r20
	ldd	r20	,Y+MOT_SSP2+1
	sbc	r17	,r20
	ldd	r20	,Y+MOT_SSP2
	sbc	r16	,r20
	rjmp	mot_speed

mot_speed_plus1:
	ldd	r16	,Y+MOT_SSP1
	ldd	r17	,Y+MOT_SSP1+1
	ldd	r18	,Y+MOT_SSP1+2
	ldd	r19	,Y+MOT_SSP1+3
	rjmp	mot_speed

mot_speed_minus1:
	clr	r16
	clr	r17
	clr	r18
	clr	r19
	ldd	r20	,Y+MOT_SSP1+3
	sub	r19	,r20
	ldd	r20	,Y+MOT_SSP1+2
	sbc	r18	,r20
	ldd	r20	,Y+MOT_SSP1+1
	sbc	r17	,r20
	ldd	r20	,Y+MOT_SSP1
	sbc	r16	,r20
	rjmp	mot_speed

mot_speed:
	cli				;add goto/tracking speed
	ldd	r2	,Y+MOT_GSP
	ldd	r3	,Y+MOT_GSP+1
	ldd	r4	,Y+MOT_GSP+2
	ldd	r5	,Y+MOT_GSP+3
	sei

	add	r19	,r5
	adc	r18	,r4
	adc	r17	,r3
	adc	r16	,r2

	cli				;new speed setpoint
	std	Y+MOT_SSP	,r16
	std	Y+MOT_SSP+1	,r17
	std	Y+MOT_SSP+2	,r18
	std	Y+MOT_SSP+3	,r19
	sei
	ret

mot_acc_plus:
	ret

mot_acc_minus:
	ret

;*****************************************************************************************
;	Stepper motor ramp calculations
;	called from the timer 1,3 interrupt routines
;	when timer reached OCR0 and starts at zero
;
;Parameters	yh:yl	adress of motor data block
.CSEG

mot_ramp:
	cli
	ldd	r2	,Y+MOT_SP		;speed
	ldd	r3	,Y+MOT_SP+1
	ldd	r4	,Y+MOT_SP+2
	ldd	r5	,Y+MOT_SP+3
	sei

	cli
	ldd	r6	,Y+MOT_SSP		;speed setpoint
	ldd	r7	,Y+MOT_SSP+1
	ldd	r8	,Y+MOT_SSP+2
	ldd	r9	,Y+MOT_SSP+3
	sei

	cli
	ldd	r10	,Y+MOT_ACC		;acceleration
	ldd	r11	,Y+MOT_ACC+1
	ldd	r12	,Y+MOT_ACC+2
	ldd	r13	,Y+MOT_ACC+3
	sei

	mov	r16	,r2		;offset 0x80 for high byte of speed and setpoint
	subi	r16	,0x80		;for simpler comparisons
	mov	r17	,r6
	subi	r17	,0x80

	cp	r5	,r9
	cpc	r4	,r8
	cpc	r3	,r7
	cpc	r16	,r17
	breq	mot_ramp_end			;speed == setpoint, nothing to do

	brcc	mot_ramp_minus			;speed > setpoint

mot_ramp_plus:
	add	r5	,r13		;speed += accereration
	adc	r4	,r12
	adc	r3	,r11
	adc	r2	,r10
	mov	r16	,r2
	subi	r16	,0x80

	cp	r9	,r5		;too fast (speed > setpoint)
	cpc	r8	,r4
	cpc	r7	,r3
	cpc	r17	,r16
	brcs	mot_ramp_equal			;yes, set speed := setpoint
	rjmp	mot_ramp_end


mot_ramp_minus:
	sub	r5	,r13		;speed -= accereration
	sbc	r4	,r12
	sbc	r3	,r11
	sbc	r2	,r10
	mov	r16	,r2
	subi	r16	,0x80

	cp	r5	,r9		;too slow (speed < setpoint)
	cpc	r4	,r8
	cpc	r3	,r7
	cpc	r16	,r17
	brcs	mot_ramp_equal			;yes, set speed := setpoint
	rjmp	mot_ramp_end

mot_ramp_equal:
	mov	r2	,r6
	mov	r3	,r7
	mov	r4	,r8
	mov	r5	,r9

mot_ramp_end:
	cli
	std	Y+MOT_SP	,r2
	std	Y+MOT_SP+1	,r3
	std	Y+MOT_SP+2	,r4
	std	Y+MOT_SP+3	,r5
	sei
	
	reti



      
;*****************************************************************************************
;	Stepper Motor Initialization
;	High Level
;*****************************************************************************************

.CSEG

stepper_init:

;	Motor A


	ldi	yl	,low(mot_a)
	ldi	yh	,high(mot_a)

	ldi	r16	,byte4(MOT_INIT_POS_A)	;position of motor A
	ldi	r17	,byte3(MOT_INIT_POS_A)
	ldi	r18	,high (MOT_INIT_POS_A)
	ldi	r19	,low  (MOT_INIT_POS_A)
	ldi	r20	,0
	ldi	r21	,0
	std	Y+MOT_POS	,r16
	std	Y+MOT_POS+1	,r17
	std	Y+MOT_POS+2	,r18
	std	Y+MOT_POS+3	,r19
	std	Y+MOT_POS+4	,r20
	std	Y+MOT_POS+5	,r21

	ldi	r16	,byte4(MOT_INIT_SP_A)	;speed of motor A
	ldi	r17	,byte3(MOT_INIT_SP_A)
	ldi	r18	,high (MOT_INIT_SP_A)
	ldi	r19	,low  (MOT_INIT_SP_A)
	std	Y+MOT_SP	,r16
	std	Y+MOT_SP+1	,r17
	std	Y+MOT_SP+2	,r18
	std	Y+MOT_SP+3	,r19

	ldi	r20	,byte4(MOT_INIT_GSP_A)	;tracking/goto speed of motor A
	ldi	r21	,byte3(MOT_INIT_GSP_A)
	ldi	r22	,high (MOT_INIT_GSP_A)
	ldi	r23	,low  (MOT_INIT_GSP_A)
	std	Y+MOT_GSP	,r20
	std	Y+MOT_GSP+1	,r21
	std	Y+MOT_GSP+2	,r22
	std	Y+MOT_GSP+3	,r23

	add	r19	,r23
	adc	r18	,r22
	adc	r17	,r21
	adc	r16	,r20
	std	Y+MOT_SSP	,r16		;speed setpoint of motor A
	std	Y+MOT_SSP+1	,r17
	std	Y+MOT_SSP+2	,r18
	std	Y+MOT_SSP+3	,r19

	clr	r16
	std	Y+MOT_HSMODE	,r16

	ldi	r16	,byte4(MOT_INIT_SSP1_A)	;speed setpoint 1 of motor A
	ldi	r17	,byte3(MOT_INIT_SSP1_A)
	ldi	r18	,high (MOT_INIT_SSP1_A)
	ldi	r19	,low  (MOT_INIT_SSP1_A)
	std	Y+MOT_SSP1	,r16
	std	Y+MOT_SSP1+1	,r17
	std	Y+MOT_SSP1+2	,r18
	std	Y+MOT_SSP1+3	,r19

	ldi	r16	,byte4(MOT_INIT_SSP2_A)	;speed setpoint 2 of motor A
	ldi	r17	,byte3(MOT_INIT_SSP2_A)
	ldi	r18	,high (MOT_INIT_SSP2_A)
	ldi	r19	,low  (MOT_INIT_SSP2_A)
	std	Y+MOT_SSP2	,r16
	std	Y+MOT_SSP2+1	,r17
	std	Y+MOT_SSP2+2	,r18
	std	Y+MOT_SSP2+3	,r19

	ldi	r16	,byte4(MOT_INIT_SSP3_A)	;speed setpoint 3 of motor A
	ldi	r17	,byte3(MOT_INIT_SSP3_A)
	ldi	r18	,high (MOT_INIT_SSP3_A)
	ldi	r19	,low  (MOT_INIT_SSP3_A)
	std	Y+MOT_SSP3	,r16
	std	Y+MOT_SSP3+1	,r17
	std	Y+MOT_SSP3+2	,r18
	std	Y+MOT_SSP3+3	,r19

	ldi	r16	,byte4(MOT_INIT_SSP4_A)	;speed setpoint 4 of motor A
	ldi	r17	,byte3(MOT_INIT_SSP4_A)
	ldi	r18	,high (MOT_INIT_SSP4_A)
	ldi	r19	,low  (MOT_INIT_SSP4_A)
	std	Y+MOT_SSP4	,r16
	std	Y+MOT_SSP4+1	,r17
	std	Y+MOT_SSP4+2	,r18
	std	Y+MOT_SSP4+3	,r19

	ldi	r16	,byte4(MOT_INIT_SSP5_A)	;speed setpoint 5 of motor A
	ldi	r17	,byte3(MOT_INIT_SSP5_A)
	ldi	r18	,high (MOT_INIT_SSP5_A)
	ldi	r19	,low  (MOT_INIT_SSP5_A)
	std	Y+MOT_SSP5	,r16
	std	Y+MOT_SSP5+1	,r17
	std	Y+MOT_SSP5+2	,r18
	std	Y+MOT_SSP5+3	,r19

	ldi	r16	,byte4(MOT_INIT_ACC_A)	;acceleration of motor A
	ldi	r17	,byte3(MOT_INIT_ACC_A)
	ldi	r18	,high (MOT_INIT_ACC_A)
	ldi	r19	,low  (MOT_INIT_ACC_A)
	std	Y+MOT_ACC	,r16
	std	Y+MOT_ACC+1	,r17
	std	Y+MOT_ACC+2	,r18
	std	Y+MOT_ACC+3	,r19

;	Motor B

	ldi	yl	,low(mot_b)
	ldi	yh	,high(mot_b)

	ldi	r16	,byte4(MOT_INIT_POS_B)	;position of motor B
	ldi	r17	,byte3(MOT_INIT_POS_B)
	ldi	r18	,high (MOT_INIT_POS_B)
	ldi	r19	,low  (MOT_INIT_POS_B)
	ldi	r20	,0
	ldi	r21	,0
	std	Y+MOT_POS	,r16
	std	Y+MOT_POS+1	,r17
	std	Y+MOT_POS+2	,r18
	std	Y+MOT_POS+3	,r19
	std	Y+MOT_POS+4	,r20
	std	Y+MOT_POS+5	,r21

	ldi	r16	,byte4(MOT_INIT_SP_B)	;speed of motor B
	ldi	r17	,byte3(MOT_INIT_SP_B)
	ldi	r18	,high (MOT_INIT_SP_B)
	ldi	r19	,low  (MOT_INIT_SP_B)
	std	Y+MOT_SP	,r16
	std	Y+MOT_SP+1	,r17
	std	Y+MOT_SP+2	,r18
	std	Y+MOT_SP+3	,r19

	ldi	r20	,byte4(MOT_INIT_GSP_B)	;tracking/goto speed of motor B
	ldi	r21	,byte3(MOT_INIT_GSP_B)
	ldi	r22	,high (MOT_INIT_GSP_B)
	ldi	r23	,low  (MOT_INIT_GSP_B)
	std	Y+MOT_GSP	,r20
	std	Y+MOT_GSP+1	,r21
	std	Y+MOT_GSP+2	,r22
	std	Y+MOT_GSP+3	,r23

	add	r19	,r23
	adc	r18	,r22
	adc	r17	,r21
	adc	r16	,r20
	std	Y+MOT_SSP	,r16		;speed setpoint of motor B
	std	Y+MOT_SSP+1	,r17
	std	Y+MOT_SSP+2	,r18
	std	Y+MOT_SSP+3	,r19

	clr	r16
	std	Y+MOT_HSMODE	,r16

	ldi	r16	,byte4(MOT_INIT_SSP1_B)	;speed setpoint 1 of motor B
	ldi	r17	,byte3(MOT_INIT_SSP1_B)
	ldi	r18	,high (MOT_INIT_SSP1_B)
	ldi	r19	,low  (MOT_INIT_SSP1_B)
	std	Y+MOT_SSP1	,r16
	std	Y+MOT_SSP1+1	,r17
	std	Y+MOT_SSP1+2	,r18
	std	Y+MOT_SSP1+3	,r19

	ldi	r16	,byte4(MOT_INIT_SSP2_B)	;speed setpoint 2 of motor B
	ldi	r17	,byte3(MOT_INIT_SSP2_B)
	ldi	r18	,high (MOT_INIT_SSP2_B)
	ldi	r19	,low  (MOT_INIT_SSP2_B)
	std	Y+MOT_SSP2	,r16
	std	Y+MOT_SSP2+1	,r17
	std	Y+MOT_SSP2+2	,r18
	std	Y+MOT_SSP2+3	,r19

	ldi	r16	,byte4(MOT_INIT_SSP3_B)	;speed setpoint 3 of motor B
	ldi	r17	,byte3(MOT_INIT_SSP3_B)
	ldi	r18	,high (MOT_INIT_SSP3_B)
	ldi	r19	,low  (MOT_INIT_SSP3_B)
	std	Y+MOT_SSP3	,r16
	std	Y+MOT_SSP3+1	,r17
	std	Y+MOT_SSP3+2	,r18
	std	Y+MOT_SSP3+3	,r19

	ldi	r16	,byte4(MOT_INIT_SSP4_B)	;speed setpoint 4 of motor B
	ldi	r17	,byte3(MOT_INIT_SSP4_B)
	ldi	r18	,high (MOT_INIT_SSP4_B)
	ldi	r19	,low  (MOT_INIT_SSP4_B)
	std	Y+MOT_SSP4	,r16
	std	Y+MOT_SSP4+1	,r17
	std	Y+MOT_SSP4+2	,r18
	std	Y+MOT_SSP4+3	,r19

	ldi	r16	,byte4(MOT_INIT_SSP5_B)	;speed setpoint 5 of motor B
	ldi	r17	,byte3(MOT_INIT_SSP5_B)
	ldi	r18	,high (MOT_INIT_SSP5_B)
	ldi	r19	,low  (MOT_INIT_SSP5_B)
	std	Y+MOT_SSP5	,r16
	std	Y+MOT_SSP5+1	,r17
	std	Y+MOT_SSP5+2	,r18
	std	Y+MOT_SSP5+3	,r19

	ldi	r16	,byte4(MOT_INIT_ACC_B)	;acceleration of motor A
	ldi	r17	,byte3(MOT_INIT_ACC_B)
	ldi	r18	,high (MOT_INIT_ACC_B)
	ldi	r19	,low  (MOT_INIT_ACC_B)
	std	Y+MOT_ACC	,r16
	std	Y+MOT_ACC+1	,r17
	std	Y+MOT_ACC+2	,r18
	std	Y+MOT_ACC+3	,r19

	ret

      

;*****************************************************************************************
