

;*****************************************************************************************
;	Mega 128 Scope Controller Program
;	(c) Martin Cibulski
;*****************************************************************************************

obj_test:
	ldi	r16	,low(5729)
	ldi	r17	,high(5729)
	ldi	r18	,4
	ldi	xl	,low(obj_ds_name)
	ldi	xh	,high(obj_ds_name)
	call	itoa

	rcall	obj_calc_dir_pointers

	ldi	r16	,2
	rcall	obj_db_open

	ldi	r16	,8
	ldi	r17	,0
	rcall	obj_db_read_dataset

	ldi	r16	,0
	call	obj_db_open
	ldi	r16	,59
	ldi	r17	,0
	call	obj_db_read_dataset
	ldi	xl	,low(obj_ds_name)
	ldi	xh	,high(obj_ds_name)
	call	lcd_print_x2
	ret

;*****************************************************************************************

;Directory of Databases

;No of directory slots
.EQU	OBJ_DIR_SLOTS	= 8

;DB Storage types
.EQU	OBJ_DB_EMPTY	= 0
.EQU	OBJ_DB_FLASH	= 1
.EQU	OBJ_DB_RAM	= 2
.EQU	OBJ_DB_EEPROM	= 4
.EQU	OBJ_DB_XEEPROM	= 8

;DB Field Types
.EQU	OBJ_FLD_NONE	= 0
.EQU	OBJ_FLD_NAME	= 1
.EQU	OBJ_FLD_INT_RA	= 2
.EQU	OBJ_FLD_INT_DEC	= 3

.EQU	OBJ_DB_OFF_DSETS	= 2+2+24

;****************************************************************************************

.EQU	OBJ_DIR_OFF_NAME	= 1
.EQU	OBJ_DIR_OFF_ADDR	= 9
.EQU	OBJ_DIR_ENTRYSIZE	= 11

.ESEG
obj_directory:
	.db	OBJ_DB_FLASH	,"STARS   "
	.dw	obj_db_stars

	.db	OBJ_DB_FLASH	,"NGC     "
	.dw	obj_db_ngc

	.db	OBJ_DB_EMPTY	,"<EMPTY> "
	.dw	0

	.db	OBJ_DB_FLASH	,"IC      "
	.dw	obj_db_ic

	.db	OBJ_DB_EMPTY	,"<EMPTY> "
	.dw	0

	.db	OBJ_DB_EMPTY	,"<EMPTY> "
	.dw	0

	.db	OBJ_DB_EMPTY	,"<EMPTY> "
	.dw	0

	.db	OBJ_DB_EMPTY	,"<EMPTY> "
	.dw	0


;****************************************************************************************

.DSEG

obj_used_slots:	.byte	1
obj_slt_low:	.byte	OBJ_DIR_SLOTS
obj_slt_high:	.byte	OBJ_DIR_SLOTS

obj_db_number:	.byte	1
obj_db_name:	.byte	8
obj_db_start:	.byte	3
obj_db_datasets:	.byte	2
obj_db_fields:	.byte	24+1
obj_db_ds_size:	.byte	1

obj_ds_number:	.byte	2
obj_ds_name:	.byte	8
obj_ds_int_ra:	.byte	2
obj_ds_int_dec:	.byte	2

;****************************************************************************************

.CSEG
obj_calc_dir_pointers:
	push	r17			;slot counter
	push	r18			;used slot counter
	push	yl			;directory entry ptr
	push	yh
	push	zl
	push	zh

	ldi	zl	,low(obj_directory)	;read type of directory entry
	ldi	zh	,high(obj_directory)
	ldi	yl	,low(obj_slt_low)
	ldi	yh	,high(obj_slt_low)
	clr	r17
	clr	r18

obj_cdp_loop:
	call	eep_read
	cpi	r16	,OBJ_DB_EMPTY		;slot empty ?
	breq	obj_cdp_01			;yes, next slot

	st	Y	,zl		;set ptr to used dir entry
	std	Y+OBJ_DIR_SLOTS	,zh

	adiw	yh:yl	,1
	inc	r18

obj_cdp_01:
	adiw	zh:zl	,OBJ_DIR_ENTRYSIZE
	inc	r17			;next slot
	cpi	r17	,OBJ_DIR_SLOTS		;all slots tested ?
	brne	obj_cdp_loop			;no

	sts	obj_used_slots	,r18		;save no of used slots

	pop	zh
	pop	zl
	pop	yh
	pop	yl
	pop	r18
	pop	r17
	ret


;****************************************************************************************
;r16	entry number (in used slot list)
;xh:xl	RAM buffer for name (8 bytes)

obj_dir_get_name:
	push	r16
	push	r17
	push	yl
	push	yh
	push	zl
	push	zh

	ldi	yl	,low(obj_slt_low)
	ldi	yh	,high(obj_slt_low)
	add	yl	,r16
	clr	r16
	adc	yh	,r16
	ld	zl	,Y
	ldd	zh	,Y+OBJ_DIR_SLOTS
	adiw	zh:zl	,OBJ_DIR_OFF_NAME

	ldi	r17	,8

obj_dgn_loop:
	call	eep_read
	adiw	zh:zl	,1
	st	X+	,r16
	dec	r17
	brne	obj_dgn_loop

	sbiw	xh:xl	,8
	pop	zh
	pop	zl
	pop	yh
	pop	yl
	pop	r17
	pop	r16
	ret
	

;****************************************************************************************
;r16	database number (in used slot list)

obj_db_open:
	push	r17
	push	r24
	push	r25
	push	yl
	push	yh
	push	zl
	push	zh

	sts	obj_db_number	,r16

	ldi	xl	,low(obj_db_name)
	ldi	xh	,high(obj_db_name)
	rcall	obj_dir_get_name
	
	ldi	yl	,low(obj_slt_low)
	ldi	yh	,high(obj_slt_low)
	add	yl	,r16
	clr	r16
	adc	yh	,r16

	ld	zl	,Y		;ptr to directory entry
	ldd	zh	,Y+OBJ_DIR_SLOTS
	adiw	zh:zl	,OBJ_DIR_OFF_ADDR		;ptr to file start adress

	clr	r1
	call	eep_read			;file start adress
	mov	r0	,r16
	adiw	zh:zl	,1
	call	eep_read
	lsl	r0
	rol	r16
	rol	r1

	sts	obj_db_start	,r0
	sts	obj_db_start+1	,r16
	sts	obj_db_start+2	,r1

	ldi	r24	,0
	ldi	r25	,0
	rcall	obj_db_read
	sts	obj_db_datasets	,r16
	rcall	obj_db_read
	sts	obj_db_datasets+1	,r16

	rcall	obj_db_read
	sts	obj_db_ds_size	,r16
	rcall	obj_db_read
	sts	obj_db_ds_size+1	,r16

	ldi	r17	,12		;read field list
	ldi	xl	,low(obj_db_fields)
	ldi	xh	,high(obj_db_fields)
obj_dbo_01:
	rcall	obj_db_read			;field type
	st	X+	,r16
	rcall	obj_db_read			;field size (bits)
	st	X+	,r16
	dec	r17
	brne	obj_dbo_01

	ldi	r16	,OBJ_FLD_NONE
	st	X	,r16

	pop	zh
	pop	zl
	pop	yh
	pop	yl
	pop	r25
	pop	r24
	pop	r17
	ret


;****************************************************************************************
;read dataset from memory file into field variables
;
;r17:r16	dataset no
;****************************************************************************************

obj_db_read_dataset:
	push	r18
	push	r24
	push	r25
	push	xl
	push	xh
	push	yl
	push	yh
	push	zl
	push	zh

	sts	obj_ds_number	,r16		;16 bit number
	sts	obj_ds_number+1	,r17

	ldi	yl	,low(obj_db_name)		;copy db name as first part
	ldi	yh	,high(obj_db_name)	;of default object name
	ldi	xl	,low(obj_ds_name)
	ldi	xh	,high(obj_ds_name+1)
	ldi	r24	,' '
	ldi	r25	,0
	clr	r0

obj_rds_00:
	ld	r1	,Y+
	st	X+	,r1
	cpse	r1	,r24
	mov	r0	,r25		;save position of last non space

	inc	r25			;copy next char
	cpi	r25	,8
	brne	obj_rds_00

	mov	r25	,r0		;db name more than 4 characters long ?
	inc	r25
	cpi	r25	,4
	brcs	obj_rds_02			;no, may be printed before number

	sts	obj_ds_name+0	,r24		;yes, number must be printed alone
	sts	obj_ds_name+1	,r24		;delete db name from buffer
	sts	obj_ds_name+6	,r24
	sts	obj_ds_name+7	,r24
	ldi	r25	,2

obj_rds_02:
	ldi	xl	,low(obj_ds_name)		;set number as default name
	ldi	xh	,high(obj_ds_name+1)
	add	xl	,r25
	clr	r25
	adc	xh	,r25
	ldi	r18	,4
	call	itoa

	ldi	r24	,low(OBJ_DB_OFF_DSETS)	;calculate file pointer
	ldi	r25	,high(OBJ_DB_OFF_DSETS)	;r25:r24
	lds	r18	,obj_db_ds_size
	mul	r16	,r18
	add	r24	,r0
	adc	r25	,r1
	mul	r17	,r18
	add	r25	,r0

	ldi	yl	,low(obj_db_fields)	;field types and sizes
	ldi	yh	,high(obj_db_fields)

obj_rds_loop:
	ld	r16	,Y+		;field type
	ld	r17	,Y+		;field size (bits)
	cpi	r16	,OBJ_FLD_NONE		;end of field list ?
	brne	obj_rds_check_name		;no, check field type

	pop	zh			;yes, return
	pop	zl
	pop	yh
	pop	yl
	pop	xh
	pop	xl
	pop	r25
	pop	r24
	pop	r18
	ret

obj_rds_check_name:
	cpi	r16	,OBJ_FLD_NAME		;NAME field ?
	brne	obj_rds_check_int_ra		;no

	ldi	xl	,low(obj_ds_name)		;read 64 bits NAME
	ldi	xh	,high(obj_ds_name+1)
obj_rds_01:
	rcall	obj_db_read
	st	X+	,r16
	subi	r17	,8
	brne	obj_rds_01
	rjmp	obj_rds_loop

obj_rds_check_int_ra:
	cpi	r16	,OBJ_FLD_INT_RA		;RA field ?
	brne	obj_rds_check_int_dec		;no

	rcall	obj_db_read
	sts	obj_ds_int_ra	,r16
	rcall	obj_db_read
	sts	obj_ds_int_ra+1	,r16
	rjmp	obj_rds_loop

obj_rds_check_int_dec:
	cpi	r16	,OBJ_FLD_INT_DEC		;DEC field ?
	brne	obj_rds_check_end			;no

	rcall	obj_db_read
	sts	obj_ds_int_dec	,r16
	rcall	obj_db_read
	sts	obj_ds_int_dec+1	,r16
	rjmp	obj_rds_loop

obj_rds_check_end:				;UNKNOWN field ?
	;read bits 
	rjmp	obj_rds_loop




	

;****************************************************************************************
;read byte from memory file
;
;r25:r24	byte offset into file
;****************************************************************************************

obj_db_read:
	push	zl
	push	zh

	clr	r0
	lds	zl	,obj_db_start		;24 bit file start adress
	lds	zh	,obj_db_start+1
	lds	r1	,obj_db_start+2
	add	zl	,r24		;add byte offset
	adc	zh	,r25
	adc	r1	,r0
	out	rampz	,r1
	elpm	r16	,Z
	adiw	r25:r24	,1

	pop	zh
	pop	zl
	ret
	

;****************************************************************************************

obj_db_stars:	.dw	64			;no of datasets
	.dw	12			;dataset size

	.db	OBJ_FLD_NAME	,64		;dataset fields list
	.db	OBJ_FLD_INT_RA	,16		;type , bits
	.db	OBJ_FLD_INT_DEC	,16
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0

	.db	"And Alp ",0x79,0x01,0xE8,0x28
	.db	"And Bet ",0x41,0x0C,0x17,0x32
	.db	"Aql Alp ",0x51,0xD1,0x78,0x0C
	.db	"Ari Alp ",0x5A,0x16,0xFE,0x20
	.db	"Aur Alp ",0xAB,0x37,0xAF,0x40
	.db	"Aur Bet ",0x32,0x3F,0x35,0x3F
	.db	"Boo Alp ",0x68,0x96,0xF9,0x1A
	.db	"Car Alp ",0x7D,0x43,0xE6,0xB5
	.db	"Car Bet ",0x3E,0x61,0xF6,0x9D
	.db	"Car Eps ",0x55,0x58,0x51,0xAC
	.db	"Cen Alp1",0x9D,0x9A,0x74,0xAA
	.db	"Cen Alp2",0x9E,0x9A,0x74,0xAA
	.db	"Cen Bet ",0x54,0x94,0x1A,0xAB
	.db	"Cen Gam ",0xDC,0x85,0x27,0xBB
	.db	"Cen The ",0xD4,0x94,0xDB,0xCC
	.db	"Cet Bet ",0xA9,0x07,0xB5,0xE6
	.db	"CMa Alp ",0x37,0x47,0x7F,0xE8
	.db	"CMa Bet ",0x45,0x43,0xC0,0xE6
	.db	"CMa Del ",0x4D,0x4B,0xE3,0xDA
	.db	"CMa Eps ",0x96,0x49,0x42,0xD7
	.db	"CMi Alp ",0xBC,0x50,0x59,0x07
	.db	"Cru Alp1",0x3C,0x83,0x45,0xA7
	.db	"Cru Alp2",0x3D,0x83,0x45,0xA7
	.db	"Cru Bet ",0xF3,0x86,0x11,0xAC
	.db	"Cru Gam ",0x0A,0x84,0xB0,0xAF
	.db	"Cyg Alp ",0x38,0xDA,0xAC,0x3F
	.db	"Cyg Gam ",0xD8,0xD6,0x9C,0x38
	.db	"Eri Alp ",0x2D,0x11,0x83,0xAF
	.db	"Gem Alp ",0xE9,0x4F,0xD7,0x2C
	.db	"Gem Bet ",0xCB,0x51,0x69,0x27
	.db	"Gem Gam ",0xE9,0x45,0x0F,0x17
	.db	"Gru Alp ",0x7A,0xE9,0xF6,0xBD
	.db	"Gru Bet ",0x88,0xEF,0x12,0xBE
	.db	"Hya Alp ",0xC5,0x63,0xD3,0xF3
	.db	"Leo Alp ",0xF0,0x6A,0xD4,0x10
	.db	"Leo Bet ",0xA3,0x7C,0x7D,0x14
	.db	"Lyr Alp ",0x56,0xC4,0x8A,0x36
	.db	"Oph Alp ",0x70,0xB9,0xA9,0x11
	.db	"Ori Alp ",0x6E,0x3E,0x6A,0x0A
	.db	"Ori Bet ",0x4A,0x37,0x78,0xF4
	.db	"Ori Eps ",0x19,0x3B,0x50,0xFE
	.db	"Ori Gam ",0x26,0x39,0xED,0x08
	.db	"Ori Kap ",0x21,0x3D,0x67,0xF2
	.db	"Ori Zet ",0xE6,0x3B,0x45,0xFD
	.db	"Pav Alp ",0x72,0xD7,0x38,0xB0
	.db	"Per Alp ",0xEA,0x23,0x1E,0x46
	.db	"Per Bet ",0x13,0x21,0x98,0x39
	.db	"PsA Alp ",0x2A,0xF2,0x58,0xD6
	.db	"Sco Alp ",0xEB,0xAD,0xD5,0xDA
	.db	"Sco Lam ",0x34,0xB9,0xD3,0xCB
	.db	"Sco The ",0xDB,0xB9,0x89,0xC3
	.db	"Sgr Eps ",0x17,0xC2,0xA6,0xCF
	.db	"Sgr Sig ",0x8E,0xC7,0x06,0xDB
	.db	"Tau Alp ",0x80,0x30,0x37,0x17
	.db	"Tau Bet ",0x5B,0x39,0x3A,0x28
	.db	"TrA Alp ",0x4D,0xB1,0xEE,0x9E
	.db	"UMa Alp ",0xAB,0x74,0xD6,0x56
	.db	"UMa Eps ",0x0F,0x88,0xB1,0x4E
	.db	"UMa Eta ",0x77,0x91,0x58,0x45
	.db	"UMi Alp ",0xAF,0x1A,0x87,0x7D
	.db	"UMi Bet ",0x91,0x9C,0x48,0x68
	.db	"Vel Del ",0x3B,0x5C,0x11,0xB3
	.db	"Vel Gam2",0x0D,0x56,0x6F,0xBD
	.db	"Vir Alp ",0x89,0x8D,0x4E,0xF0

;****************************************************************************************

obj_db_ngc:	.dw	7840			;no of datasets
	.dw	6			;dataset size

	.db	OBJ_FLD_INT_RA	,64		;dataset fields list
	.db	OBJ_FLD_INT_DEC	,16		;type , bits
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0

.include "NGC.txt"

;****************************************************************************************

obj_db_ic:	.dw	5386			;no of datasets
	.dw	6			;dataset size

	.db	OBJ_FLD_INT_RA	,64		;dataset fields list
	.db	OBJ_FLD_INT_DEC	,16		;type , bits
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0
	.db	OBJ_FLD_NONE	, 0

.include "IC.txt"

;*****************************************************************************************
